###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kernel MDKSA-2007:047 (kernel)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830335);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:047");
  script_cve_id("CVE-2006-5701", "CVE-2006-5823", "CVE-2007-0006");
  script_name(english: "Mandriva Update for kernel MDKSA-2007:047 (kernel)");
  desc["english"] = "

  Vulnerability Insight:

  Some vulnerabilities were discovered and corrected in the Linux 2.6
  kernel:
  
  A double free vulnerability in the squashfs module could allow a local
  user to cause a Denial of Service by mounting a crafted squashfs
  filesystem (CVE-2006-5701).
  
  The zlib_inflate function allows local users to cause a crash via a
  malformed filesystem that uses zlib compression that triggers memory
  corruption (CVE-2006-5823).
  
  The key serial number collision avoidance code in the key_alloc_serial
  function in kernels 2.6.9 up to 2.6.20 allows local users to cause a
  crash via vectors thatr trigger a null dereference (CVE-2007-0006).
  
  The provided packages are patched to fix these vulnerabilities.  All
  users are encouraged to upgrade to these updated kernels immediately
  and reboot to effect the fixes.
  
  In addition to these security fixes, other fixes have been included
  such as:
  
  - New drivers: nozomi, UVC
  - Fixed SiS SATA support for chips on 966/968 bridges
  - Fixed issues in squashfs by updating to 3.2 (#27008)
  - Added support for SiS968 bridgest to the sis190 bridge
  - Fixed JMicron cable detection
  - Added /proc/config.gz support and enabled kexec on x86_64
  - Other minor fixes
  
  To update your kernel, please follow the directions located at:
  
  http://www.mandriva.com/en/security/kernelupdate

  Affected Software/OS:
  kernel on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-02/msg00018.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.17.11mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.17.11mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-enterprise", rpm:"kernel-enterprise~2.6.17.11mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-legacy", rpm:"kernel-legacy~2.6.17.11mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.17.11mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source-stripped", rpm:"kernel-source-stripped~2.6.17.11mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen0", rpm:"kernel-xen0~2.6.17.11mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.17.11mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}