###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for snort MDKSA-2007:051 (snort)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830299);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:051");
  script_cve_id("CVE-2006-6931");
  script_name(english: "Mandriva Update for snort MDKSA-2007:051 (snort)");
  desc["english"] = "

  Vulnerability Insight:

  Algorithmic complexity vulnerability in Snort before 2.6.1, during
  predicate evaluation in rule matching for certain rules, allows remote
  attackers to cause a denial of service (CPU consumption and detection
  outage) via crafted network traffic, aka a backtracking attack.
  
  Updated packages have been patched to address this issue.

  Affected Software/OS:
  snort on Mandriva Linux 2006.0,
  Mandriva Linux 2006.0/X86_64,
  Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-03/msg00000.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of snort");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"snort", rpm:"snort~2.6.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-bloat", rpm:"snort-bloat~2.6.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-inline+flexresp", rpm:"snort-inline+flexresp~2.6.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-inline", rpm:"snort-inline~2.6.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-mysql+flexresp", rpm:"snort-mysql+flexresp~2.6.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-mysql", rpm:"snort-mysql~2.6.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-plain+flexresp", rpm:"snort-plain+flexresp~2.6.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-postgresql+flexresp", rpm:"snort-postgresql+flexresp~2.6.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-postgresql", rpm:"snort-postgresql~2.6.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-prelude+flexresp", rpm:"snort-prelude+flexresp~2.6.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-prelude", rpm:"snort-prelude~2.6.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2006.0")
{

  if(isrpmvuln(pkg:"snort", rpm:"snort~2.3.3~2.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-bloat", rpm:"snort-bloat~2.3.3~2.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-inline+flexresp", rpm:"snort-inline+flexresp~2.3.3~2.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-inline", rpm:"snort-inline~2.3.3~2.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-mysql+flexresp", rpm:"snort-mysql+flexresp~2.3.3~2.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-mysql", rpm:"snort-mysql~2.3.3~2.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-plain+flexresp", rpm:"snort-plain+flexresp~2.3.3~2.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-postgresql+flexresp", rpm:"snort-postgresql+flexresp~2.3.3~2.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-postgresql", rpm:"snort-postgresql~2.3.3~2.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-snmp+flexresp", rpm:"snort-snmp+flexresp~2.3.3~2.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"snort-snmp", rpm:"snort-snmp~2.3.3~2.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}