###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for gnupg MDKSA-2007:059 (gnupg)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830318);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:059");
  script_cve_id("CVE-2007-1263");
  script_name(english: "Mandriva Update for gnupg MDKSA-2007:059 (gnupg)");
  desc["english"] = "

  Vulnerability Insight:

  GnuPG prior to 1.4.7 and GPGME prior to 1.1.4, when run from the
  command
  line, did not visually distinguish signed and unsigned portions of
  OpenPGP messages with multiple components.  This could allow a remote
  attacker to forge the contents of an email message without detection.
  
  GnuPG 1.4.7 is being provided with this update and GPGME has been
  patched on Mandriva 2007.0 to provide better visual notification on
  these types of forgeries.

  Affected Software/OS:
  gnupg on Mandriva Linux 2006.0,
  Mandriva Linux 2006.0/X86_64,
  Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-03/msg00011.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of gnupg");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"gnupg", rpm:"gnupg~1.4.7~0.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgpgme11", rpm:"libgpgme11~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgpgme11-devel", rpm:"libgpgme11-devel~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpgme", rpm:"gpgme~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gpgme11", rpm:"lib64gpgme11~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gpgme11-devel", rpm:"lib64gpgme11-devel~1.1.2~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2006.0")
{

  if(isrpmvuln(pkg:"gnupg", rpm:"gnupg~1.4.7~0.2.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}