###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mutt MDKSA-2007:113 (mutt)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830103);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:113");
  script_cve_id("CVE-2007-1558", "CVE-2007-2683");
  script_name(english: "Mandriva Update for mutt MDKSA-2007:113 (mutt)");
  desc["english"] = "

  Vulnerability Insight:

  A flaw in the way mutt processed certain APOP authentication requests
  was discovered.  By sending certain responses when mutt attempted to
  authenticate again an APOP server, a remote attacker could possibly
  obtain certain portions of the user's authentication credentials
  (CVE-2007-1558).
  
  A flaw in how mutt handled certain characters in gecos fields could
  lead to a buffer overflow.  A local user able to give themselves a
  carefully crafted Real Name could potentially execute arbitrary code
  if a victim used mutt to expand the attacker's alias (CVE-2007-2683).
  
  Updated packages have been patched to address these issues.

  Affected Software/OS:
  mutt on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-06/msg00003.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of mutt");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"mutt", rpm:"mutt~1.5.14~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mutt-utf8", rpm:"mutt-utf8~1.5.14~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"mutt", rpm:"mutt~1.5.11~5.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mutt-utf8", rpm:"mutt-utf8~1.5.11~5.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}