###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for file MDKSA-2007:114 (file)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830046);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:114");
  script_cve_id("CVE-2007-1536", "CVE-2007-2799", "CVE-2007-2026");
  script_name(english: "Mandriva Update for file MDKSA-2007:114 (file)");
  desc["english"] = "

  Vulnerability Insight:

  The update to correct CVE-2007-1536 (MDKSA-2007:067), a buffer overflow
  in the file_printf() function, introduced a new integer overflow as
  reported by Colin Percival.  This flaw, if an atacker could trick a
  user into running file on a specially crafted file, could possibly
  lead to the execution of arbitrary code with the privileges of the
  user running file (CVE-2007-2799).
  
  As well, in file 4.20, flawed regular expressions to identify OS/2
  REXX files could lead to a denial of service via CPU consumption
  (CVE-2007-2026).
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  file on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-06/msg00006.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of file");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"file", rpm:"file~4.20~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmagic1", rpm:"libmagic1~4.20~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmagic1-devel", rpm:"libmagic1-devel~4.20~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmagic1-static-devel", rpm:"libmagic1-static-devel~4.20~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-magic", rpm:"python-magic~4.20~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64magic1", rpm:"lib64magic1~4.20~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64magic1-devel", rpm:"lib64magic1-devel~4.20~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64magic1-static-devel", rpm:"lib64magic1-static-devel~4.20~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"file", rpm:"file~4.17~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmagic1", rpm:"libmagic1~4.17~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmagic1-devel", rpm:"libmagic1-devel~4.17~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmagic1-static-devel", rpm:"libmagic1-static-devel~4.17~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-magic", rpm:"python-magic~4.17~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64magic1", rpm:"lib64magic1~4.17~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64magic1-devel", rpm:"lib64magic1-devel~4.17~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64magic1-static-devel", rpm:"lib64magic1-static-devel~4.17~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}