###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for net-snmp MDKSA-2007:225 (net-snmp)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830241);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:225");
  script_cve_id("CVE-2007-5846");
  script_name(english: "Mandriva Update for net-snmp MDKSA-2007:225 (net-snmp)");
  desc["english"] = "

  Vulnerability Insight:

  The SNMP agent in net-snmp 5.4.1 and earlier allows remote attackers to
  cause a denial of service (CPU and memory consumption) via a GETBULK
  request with a large max-repeaters value.
  
  Updated packages fix this issue.

  Affected Software/OS:
  net-snmp on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00033.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of net-snmp");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libnet-snmp10", rpm:"libnet-snmp10~5.3.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnet-snmp10-devel", rpm:"libnet-snmp10-devel~5.3.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnet-snmp10-static-devel", rpm:"libnet-snmp10-static-devel~5.3.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-mibs", rpm:"net-snmp-mibs~5.3.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-trapd", rpm:"net-snmp-trapd~5.3.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-utils", rpm:"net-snmp-utils~5.3.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-NetSNMP", rpm:"perl-NetSNMP~5.3.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64net-snmp10", rpm:"lib64net-snmp10~5.3.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64net-snmp10-devel", rpm:"lib64net-snmp10-devel~5.3.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64net-snmp10-static-devel", rpm:"lib64net-snmp10-static-devel~5.3.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libnet-snmp10", rpm:"libnet-snmp10~5.3.1~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnet-snmp10-devel", rpm:"libnet-snmp10-devel~5.3.1~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnet-snmp10-static-devel", rpm:"libnet-snmp10-static-devel~5.3.1~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.3.1~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-mibs", rpm:"net-snmp-mibs~5.3.1~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-trapd", rpm:"net-snmp-trapd~5.3.1~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-utils", rpm:"net-snmp-utils~5.3.1~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-NetSNMP", rpm:"perl-NetSNMP~5.3.1~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64net-snmp10", rpm:"lib64net-snmp10~5.3.1~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64net-snmp10-devel", rpm:"lib64net-snmp10-devel~5.3.1~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64net-snmp10-static-devel", rpm:"lib64net-snmp10-static-devel~5.3.1~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}