###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for tetex MDKSA-2007:230 (tetex)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830231);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:230");
  script_cve_id("CVE-2007-4033", "CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393", "CVE-2007-5935", "CVE-2007-5936", "CVE-2007-5937");
  script_name(english: "Mandriva Update for tetex MDKSA-2007:230 (tetex)");
  desc["english"] = "

  Vulnerability Insight:

  A flaw in the t1lib library where an attacker could create a malicious
  file that would cause tetex to crash or possibly execute arbitrary
  code when opened (CVE-2007-4033).
  
  Alin Rad Pop found several flaws in how PDF files are handled in tetex.
  An attacker could create a malicious PDF file that would cause tetex to
  crash or potentially execute arbitrary code when opened (CVE-2007-4352,
  CVE-2007-5392, CVE-2007-5393).
  
  A stack-based buffer overflow in dvips in tetex allows for
  user-assisted attackers to execute arbitrary code via a DVI file with
  a long href tag (CVE-2007-5935).
  
  A vulnerability in dvips in tetex allows local users to obtain
  sensitive information and modify certain data by creating certain
  temporary files before they are processed by dviljk, which can then
  be read or modified in place (CVE-2007-5936).
  
  Multiple buffer overflows in dviljk in tetext may allow users-assisted
  attackers to execute arbitrary code via a crafted DVI input file
  (CVE-2007-5937).
  
  The updated packages have been patched to correct this issue.

  Affected Software/OS:
  tetex on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00038.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of tetex");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"jadetex", rpm:"jadetex~3.12~129.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex", rpm:"tetex~3.0~31.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-afm", rpm:"tetex-afm~3.0~31.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-context", rpm:"tetex-context~3.0~31.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-devel", rpm:"tetex-devel~3.0~31.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-doc", rpm:"tetex-doc~3.0~31.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvilj", rpm:"tetex-dvilj~3.0~31.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvipdfm", rpm:"tetex-dvipdfm~3.0~31.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvips", rpm:"tetex-dvips~3.0~31.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-latex", rpm:"tetex-latex~3.0~31.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-mfwin", rpm:"tetex-mfwin~3.0~31.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-texi2html", rpm:"tetex-texi2html~3.0~31.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-usrlocal", rpm:"tetex-usrlocal~3.0~31.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-xdvi", rpm:"tetex-xdvi~3.0~31.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xmltex", rpm:"xmltex~1.9~77.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"jadetex", rpm:"jadetex~3.12~116.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex", rpm:"tetex~3.0~18.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-afm", rpm:"tetex-afm~3.0~18.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-context", rpm:"tetex-context~3.0~18.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-devel", rpm:"tetex-devel~3.0~18.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-doc", rpm:"tetex-doc~3.0~18.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvilj", rpm:"tetex-dvilj~3.0~18.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvipdfm", rpm:"tetex-dvipdfm~3.0~18.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvips", rpm:"tetex-dvips~3.0~18.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-latex", rpm:"tetex-latex~3.0~18.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-mfwin", rpm:"tetex-mfwin~3.0~18.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-texi2html", rpm:"tetex-texi2html~3.0~18.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-xdvi", rpm:"tetex-xdvi~3.0~18.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xmltex", rpm:"xmltex~1.9~64.5mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"jadetex", rpm:"jadetex~3.12~136.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex", rpm:"tetex~3.0~38.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-afm", rpm:"tetex-afm~3.0~38.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-context", rpm:"tetex-context~3.0~38.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-devel", rpm:"tetex-devel~3.0~38.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-doc", rpm:"tetex-doc~3.0~38.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvilj", rpm:"tetex-dvilj~3.0~38.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvipdfm", rpm:"tetex-dvipdfm~3.0~38.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvips", rpm:"tetex-dvips~3.0~38.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-latex", rpm:"tetex-latex~3.0~38.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-mfwin", rpm:"tetex-mfwin~3.0~38.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-texi2html", rpm:"tetex-texi2html~3.0~38.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-usrlocal", rpm:"tetex-usrlocal~3.0~38.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-xdvi", rpm:"tetex-xdvi~3.0~38.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xmltex", rpm:"xmltex~1.9~84.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}