###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for swi-prolog MDVA-2008:099 (swi-prolog)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830449);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:099");
  script_cve_id("");
  script_name(english: "Mandriva Update for swi-prolog MDVA-2008:099 (swi-prolog)");
  desc["english"] = "

  Vulnerability Insight:

  The package included with Mandriva Linux 2008 Spring for swi-prolog
  could not be installed due to an incorrect dependency.  This updated
  package removes the incorrect dependency and can be installed as
  normal.

  Affected Software/OS:
  swi-prolog on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-06/msg00036.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of swi-prolog");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"swi-prolog", rpm:"swi-prolog~5.6.51~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"swi-prolog-jpl", rpm:"swi-prolog-jpl~5.6.51~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"swi-prolog-xpce", rpm:"swi-prolog-xpce~5.6.51~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}