###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for totem-pl-parser MDVA-2008:152 (totem-pl-parser)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830455);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:152");
  script_cve_id("");
  script_name(english: "Mandriva Update for totem-pl-parser MDVA-2008:152 (totem-pl-parser)");
  desc["english"] = "

  Vulnerability Insight:

  The totem playlist parser library was not exporting a symbol required
  by the python binding.  This update adds the symbol and fixes several
  other bugs.

  Affected Software/OS:
  totem-pl-parser on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00032.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of totem-pl-parser");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"libtotem-plparser12", rpm:"libtotem-plparser12~2.24.1~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtotem-plparser-devel", rpm:"libtotem-plparser-devel~2.24.1~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtotem-plparser-mini12", rpm:"libtotem-plparser-mini12~2.24.1~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"totem-pl-parser-i18n", rpm:"totem-pl-parser-i18n~2.24.1~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"totem-pl-parser", rpm:"totem-pl-parser~2.24.1~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64totem-plparser12", rpm:"lib64totem-plparser12~2.24.1~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64totem-plparser-devel", rpm:"lib64totem-plparser-devel~2.24.1~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64totem-plparser-mini12", rpm:"lib64totem-plparser-mini12~2.24.1~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}