###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for SDL_image MDVSA-2008:040 (SDL_image)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830690);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:040");
  script_cve_id("CVE-2007-6697", "CVE-2008-0544");
  script_name(english: "Mandriva Update for SDL_image MDVSA-2008:040 (SDL_image)");
  desc["english"] = "

  Vulnerability Insight:

  The LWZReadByte() and IMG_LoadLBM_RW() functions in SDL_image
  contain a boundary error that could be triggered to cause a static
  buffer overflow and a heap-based buffer overflow.  If a user using
  an application linked against the SDL_image library were to open a
  carefully crafted GIF or IFF ILBM file, the application could crash
  or possibly allow for the execution of arbitrary code.
  
  The updated packages have been patched to correct this issue.

  Affected Software/OS:
  SDL_image on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-02/msg00012.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of SDL_image");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libSDL_image1.2", rpm:"libSDL_image1.2~1.2.5~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libSDL_image1.2-devel", rpm:"libSDL_image1.2-devel~1.2.5~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libSDL_image1.2-test", rpm:"libSDL_image1.2-test~1.2.5~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"SDL_image", rpm:"SDL_image~1.2.5~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64SDL_image1.2", rpm:"lib64SDL_image1.2~1.2.5~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64SDL_image1.2-devel", rpm:"lib64SDL_image1.2-devel~1.2.5~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64SDL_image1.2-test", rpm:"lib64SDL_image1.2-test~1.2.5~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libSDL_image1.2", rpm:"libSDL_image1.2~1.2.5~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libSDL_image1.2-devel", rpm:"libSDL_image1.2-devel~1.2.5~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libSDL_image1.2-test", rpm:"libSDL_image1.2-test~1.2.5~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"SDL_image", rpm:"SDL_image~1.2.5~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64SDL_image1.2", rpm:"lib64SDL_image1.2~1.2.5~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64SDL_image1.2-devel", rpm:"lib64SDL_image1.2-devel~1.2.5~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64SDL_image1.2-test", rpm:"lib64SDL_image1.2-test~1.2.5~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libSDL_image1.2", rpm:"libSDL_image1.2~1.2.6~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libSDL_image1.2-devel", rpm:"libSDL_image1.2-devel~1.2.6~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libSDL_image1.2-test", rpm:"libSDL_image1.2-test~1.2.6~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"SDL_image", rpm:"SDL_image~1.2.6~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64SDL_image1.2", rpm:"lib64SDL_image1.2~1.2.6~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64SDL_image1.2-devel", rpm:"lib64SDL_image1.2-devel~1.2.6~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64SDL_image1.2-test", rpm:"lib64SDL_image1.2-test~1.2.6~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}