###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for nss_ldap MDVSA-2008:049 (nss_ldap)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830734);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:049");
  script_cve_id("CVE-2007-5794");
  script_name(english: "Mandriva Update for nss_ldap MDVSA-2008:049 (nss_ldap)");
  desc["english"] = "

  Vulnerability Insight:

  A race condition in nss_ldap, when used in applications that use
  pthread and fork after a call to nss_ldap, does not properly handle the
  LDAP connection, which might cause nss_ldap to return the wrong user
  data to the wrong process, giving one user access to data belonging
  to another user, in some cases.
  
  The updated package hais been patched to prevent this issue.

  Affected Software/OS:
  nss_ldap on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-02/msg00031.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of nss_ldap");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"nss_ldap-250", rpm:"nss_ldap-250~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}