###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for sarg MDVSA-2008:079 (sarg)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830387);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:079");
  script_cve_id("CVE-2008-1167", "CVE-2008-1168");
  script_name(english: "Mandriva Update for sarg MDVSA-2008:079 (sarg)");
  desc["english"] = "

  Vulnerability Insight:

  A stack-based buffer overflow in sarg (Squid Analysis Report Generator)
  allowed remote attackers to execute arbitrary code via a long Squid
  proxy server User-Agent header (CVE-2008-1167).
  
  A cross-site scripting vulnerability in sarg version 2.x prior to
  2.2.5 allowed remote attackers to inject arbitrary web script or
  HTML via the User-Agent heder, which is not properly handled when
  displaying the Squid proxy log (CVE-2008-1168).
  
  In addition, a number of other fixes have been made such as making
  the getword() function more robust which should prevent any overflows,
  other segfaults have been fixed, and the useragent report is now more
  consistent with the other reports.
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  sarg on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-03/msg00032.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of sarg");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"sarg", rpm:"sarg~2.2.5~0.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"sarg", rpm:"sarg~2.2.5~0.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"sarg", rpm:"sarg~2.2.5~0.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}