###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for clamav MDVSA-2008:122 (clamav)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830448);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:122");
  script_cve_id("CVE-2008-2713");
  script_name(english: "Mandriva Update for clamav MDVSA-2008:122 (clamav)");
  desc["english"] = "

  Vulnerability Insight:

  A vulnerability was discovered in ClamAV and corrected with the
  0.93.1 release:
  
  libclamav/petite.c in ClamAV before 0.93.1 allows remote attackers
  to cause a denial of service via a crafted Petite file that triggers
  an out-of-bounds read. (CVE-2008-2713)
  
  Other bugs have also been corrected in 0.93.1 which is being provided
  with this update.

  Affected Software/OS:
  clamav on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-06/msg00032.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of clamav");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.93.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.93.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-milter", rpm:"clamav-milter~0.93.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamd", rpm:"clamd~0.93.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libclamav4", rpm:"libclamav4~0.93.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libclamav-devel", rpm:"libclamav-devel~0.93.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64clamav4", rpm:"lib64clamav4~0.93.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64clamav-devel", rpm:"lib64clamav-devel~0.93.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.93.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.93.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-milter", rpm:"clamav-milter~0.93.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamd", rpm:"clamd~0.93.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libclamav4", rpm:"libclamav4~0.93.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libclamav-devel", rpm:"libclamav-devel~0.93.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64clamav4", rpm:"lib64clamav4~0.93.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64clamav-devel", rpm:"lib64clamav-devel~0.93.1~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.93.1~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.93.1~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-milter", rpm:"clamav-milter~0.93.1~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamd", rpm:"clamd~0.93.1~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libclamav4", rpm:"libclamav4~0.93.1~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libclamav-devel", rpm:"libclamav-devel~0.93.1~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64clamav4", rpm:"lib64clamav4~0.93.1~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64clamav-devel", rpm:"lib64clamav-devel~0.93.1~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}