###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for ruby MDVSA-2008:141 (ruby)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830663);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:141");
  script_cve_id("CVE-2008-1145", "CVE-2008-1891", "CVE-2008-2662", "CVE-2008-2663", "CVE-2008-2664", "CVE-2008-2725", "CVE-2008-2726", "CVE-2008-2376");
  script_name(english: "Mandriva Update for ruby MDVSA-2008:141 (ruby)");
  desc["english"] = "

  Vulnerability Insight:

  Multiple vulnerabilities have been found in the Ruby interpreter and
  in Webrick, the webserver bundled with Ruby.
  
  Directory traversal vulnerability in WEBrick in Ruby 1.8 before
  1.8.5-p115 and 1.8.6-p114, and 1.9 through 1.9.0-1, when running on
  systems that support backslash (\) path separators or case-insensitive
  file names, allows remote attackers to access arbitrary files via
  (1) ..%5c (encoded backslash) sequences or (2) filenames that match
  patterns in the :NondisclosureName option. (CVE-2008-1145)
  
  Directory traversal vulnerability in WEBrick in Ruby 1.9.0
  and earlier, when using NTFS or FAT filesystems, allows remote
  attackers to read arbitrary CGI files via a trailing (1) + (plus),
  (2) %2b (encoded plus), (3) . (dot), (4) %2e (encoded dot), or
  (5) %20 (encoded space) character in the URI, possibly related to
  the WEBrick::HTTPServlet::FileHandler and WEBrick::HTTPServer.new
  functionality and the :DocumentRoot option. (CVE-2008-1891)
  
  Multiple integer overflows in the rb_str_buf_append function in
  Ruby 1.8.4 and earlier, 1.8.5 before 1.8.5-p231, 1.8.6 before
  1.8.6-p230, 1.8.7 before 1.8.7-p22, and 1.9.0 before 1.9.0-2
  allow context-dependent attackers to execute arbitrary code or
  cause a denial of service via unknown vectors that trigger memory
  corruption. (CVE-2008-2662)
  
  Multiple integer overflows in the rb_ary_store function in Ruby
  1.8.4 and earlier, 1.8.5 before 1.8.5-p231, 1.8.6 before 1.8.6-p230,
  and 1.8.7 before 1.8.7-p22 allow context-dependent attackers to
  execute arbitrary code or cause a denial of service via unknown
  vectors. (CVE-2008-2663)
  
  The rb_str_format function in Ruby 1.8.4 and earlier, 1.8.5 before
  1.8.5-p231, 1.8.6 before 1.8.6-p230, 1.8.7 before 1.8.7-p22, and 1.9.0
  before 1.9.0-2 allows context-dependent attackers to trigger memory
  corruption via unspecified vectors related to alloca. (CVE-2008-2664)
  
  Integer overflow in the rb_ary_splice function in Ruby 1.8.4
  and earlier, 1.8.5 before 1.8.5-p231, 1.8.6 before 1.8.6-p230,
  and 1.8.7 before 1.8.7-p22 allows context-dependent attackers to
  trigger memory corruption via unspecified vectors, aka the REALLOC_N
  variant. (CVE-2008-2725)
  
  Integer overflow in the rb_ary_splice function in Ruby 1.8.4 and
  earlier, 1.8.5 before 1.8.5-p231, 1.8.6 before 1.8.6-p230, 1.8.7 before
  1.8.7-p22, and 1.9.0 before 1.9.0-2 allows context-dependent attackers
  to trigger memory corruption, aka the beg + rlen issue. (CVE-2008-2726)
  
  Integer overflow in ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  ruby on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-07/msg00020.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ruby");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"ruby", rpm:"ruby~1.8.5~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-devel", rpm:"ruby-devel~1.8.5~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-doc", rpm:"ruby-doc~1.8.5~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-tk", rpm:"ruby-tk~1.8.5~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"ruby", rpm:"ruby~1.8.6~5.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-devel", rpm:"ruby-devel~1.8.6~5.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-doc", rpm:"ruby-doc~1.8.6~5.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-tk", rpm:"ruby-tk~1.8.6~5.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}