###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for opensc MDVSA-2008:183 (opensc)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830353);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:183");
  script_cve_id("CVE-2008-2235");
  script_name(english: "Mandriva Update for opensc MDVSA-2008:183 (opensc)");
  desc["english"] = "

  Vulnerability Insight:

  Chaskiel M Grundman found that OpenSC would initialize smart cards
  with the Siemens CardOS M4 card operating system without proper access
  rights.  This allowed everyone to change the card's PIN without first
  having the PIN or PUK, or the superuser's PIN or PUK (CVE-2008-2235).
  
  Please note that this issue can not be used to discover the PIN on
  a card.  If the PIN on a card is the same that was always there,
  it is unlikely that this vulnerability has been exploited.  As well,
  this issue only affects smart cards and USB crypto tokens based on
  Siemens CardOS M4, and then only those devices that were initialized
  by OpenSC.  Users of other smart cards or USB crypto tokens, or cards
  that were not initialized by OpenSC, are not affected.
  
  After applying the update, executing 'pkcs15-tool -T' will indicate
  whether the card is fine or vulnerable.  If the card is vulnerable, the
  security settings need to be updated by executing 'pkcs15-tool -T -U'.
  
  The updated packages have been patched to prevent this issue.

  Affected Software/OS:
  opensc on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-09/msg00001.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of opensc");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libopensc2", rpm:"libopensc2~0.11.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libopensc2-devel", rpm:"libopensc2-devel~0.11.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-plugin-opensc", rpm:"mozilla-plugin-opensc~0.11.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"opensc", rpm:"opensc~0.11.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64opensc2", rpm:"lib64opensc2~0.11.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64opensc2-devel", rpm:"lib64opensc2-devel~0.11.1~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libopensc2", rpm:"libopensc2~0.11.3~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libopensc-devel", rpm:"libopensc-devel~0.11.3~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-plugin-opensc", rpm:"mozilla-plugin-opensc~0.11.3~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"opensc", rpm:"opensc~0.11.3~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64opensc2", rpm:"lib64opensc2~0.11.3~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64opensc-devel", rpm:"lib64opensc-devel~0.11.3~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"libopensc2", rpm:"libopensc2~0.11.3~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libopensc-devel", rpm:"libopensc-devel~0.11.3~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-plugin-opensc", rpm:"mozilla-plugin-opensc~0.11.3~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"opensc", rpm:"opensc~0.11.3~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64opensc2", rpm:"lib64opensc2~0.11.3~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64opensc-devel", rpm:"lib64opensc-devel~0.11.3~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}