###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for postfix MDVSA-2008:190 (postfix)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830635);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:190");
  script_cve_id("CVE-2008-3889");
  script_name(english: "Mandriva Update for postfix MDVSA-2008:190 (postfix)");
  desc["english"] = "

  Vulnerability Insight:

  A vulnerability in Postfix 2.4 and later was discovered, when
  running on Linux kernel 2.6, where a local user could cause a denial
  of service due to Postfix leaking the epoll file descriptor when
  executing non-Postfix commands (CVE-2008-3889).
  
  The updated packages have been patched to correct this issue.

  Affected Software/OS:
  postfix on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-09/msg00007.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of postfix");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libpostfix1", rpm:"libpostfix1~2.4.5~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.4.5~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-ldap", rpm:"postfix-ldap~2.4.5~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-mysql", rpm:"postfix-mysql~2.4.5~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-pcre", rpm:"postfix-pcre~2.4.5~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-pgsql", rpm:"postfix-pgsql~2.4.5~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64postfix1", rpm:"lib64postfix1~2.4.5~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"libpostfix1", rpm:"libpostfix1~2.5.1~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.5.1~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-ldap", rpm:"postfix-ldap~2.5.1~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-mysql", rpm:"postfix-mysql~2.5.1~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-pcre", rpm:"postfix-pcre~2.5.1~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postfix-pgsql", rpm:"postfix-pgsql~2.5.1~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64postfix1", rpm:"lib64postfix1~2.5.1~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}