###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libxml2 MDVSA-2008:212 (libxml2)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830722);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:212");
  script_cve_id("CVE-2008-4409");
  script_name(english: "Mandriva Update for libxml2 MDVSA-2008:212 (libxml2)");
  desc["english"] = "

  Vulnerability Insight:

  libxml2 version 2.7.0 and 2.7.1 did not properly handle predefined
  entities definitions in entities, which allowed context-dependent
  attackers to cause a denial of service (memory consumption and
  application crash) via certain XML documents (CVE-2008-4409).
  
  The updated packages have been patched to prevent this issue.

  Affected Software/OS:
  libxml2 on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00020.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libxml2");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"libxml2_2", rpm:"libxml2_2~2.7.1~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-devel", rpm:"libxml2-devel~2.7.1~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-python", rpm:"libxml2-python~2.7.1~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-utils", rpm:"libxml2-utils~2.7.1~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2", rpm:"libxml2~2.7.1~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xml2_2", rpm:"lib64xml2_2~2.7.1~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xml2-devel", rpm:"lib64xml2-devel~2.7.1~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}