###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for vim MDVSA-2008:236-1 (vim)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830451);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:236-1");
  script_cve_id("CVE-2008-2712", "CVE-2008-2953", "CVE-2008-3074", "CVE-2008-3075", "CVE-2008-3076", "CVE-2008-4101", "CVE-2008-4677");
  script_name(english: "Mandriva Update for vim MDVSA-2008:236-1 (vim)");
  desc["english"] = "

  Vulnerability Insight:

  Several vulnerabilities were found in the vim editor:
  
  A number of input sanitization flaws were found in various vim
  system functions.  If a user were to open a specially crafted file,
  it would be possible to execute arbitrary code as the user running vim
  (CVE-2008-2712).
  
  Ulf H&#xC3;&#xA4;rnhammar of Secunia Research found a format string flaw in
  vim's help tags processor.  If a user were tricked into executing the
  helptags command on malicious data, it could result in the execution
  of arbitrary code as the user running vim (CVE-2008-2953).
  
  A flaw was found in how tar.vim handled TAR archive browsing.  If a
  user were to open a special TAR archive using the plugin, it could
  result in the execution of arbitrary code as the user running vim
  (CVE-2008-3074).
  
  A flaw was found in how zip.vim handled ZIP archive browsing.  If a
  user were to open a special ZIP archive using the plugin, it could
  result in the execution of arbitrary code as the user running vim
  (CVE-2008-3075).
  
  A number of security flaws were found in netrw.vim, the vim plugin
  that provides the ability to read and write files over the network.
  If a user opened a specially crafted file or directory with the netrw
  plugin, it could result in the execution of arbitrary code as the
  user running vim (CVE-2008-3076).
  
  A number of input validation flaws were found in vim's keyword and
  tag handling.  If vim looked up a document's maliciously crafted
  tag or keyword, it was possible to execute arbitary code as the user
  running vim (CVE-2008-4101).
  
  A vulnerability was found in certain versions of netrw.vim where it
  would send FTP credentials stored for an FTP session to subsequent
  FTP sessions to servers on different hosts, exposing FTP credentials
  to remote hosts (CVE-2008-4677).
  
  This update provides vim 7.2 (patchlevel 65) which corrects all of
  these issues and introduces a number of new features and bug fixes.
  
  Update:
  
  The previous vim update incorrectly introduced a requirement on
  libruby and also conflicted with a file from the git-core package
  (in contribs).  These issues have been corrected with these updated
  packages.

  Affected Software/OS:
  vim on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64,
  Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-12/msg00010.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of vim");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"vim-common", rpm:"vim-common~7.2.065~9.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim-enhanced", rpm:"vim-enhanced~7.2.065~9.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim-minimal", rpm:"vim-minimal~7.2.065~9.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim-X11", rpm:"vim-X11~7.2.065~9.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim", rpm:"vim~7.2.065~9.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"vim-common", rpm:"vim-common~7.2.065~9.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim-enhanced", rpm:"vim-enhanced~7.2.065~9.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim-minimal", rpm:"vim-minimal~7.2.065~9.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim-X11", rpm:"vim-X11~7.2.065~9.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim", rpm:"vim~7.2.065~9.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"vim-common", rpm:"vim-common~7.2.065~9.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim-enhanced", rpm:"vim-enhanced~7.2.065~9.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim-minimal", rpm:"vim-minimal~7.2.065~9.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim-X11", rpm:"vim-X11~7.2.065~9.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim", rpm:"vim~7.2.065~9.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}