###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_memcached_detect.nasl 2114 2009-05-14 20:26:29Z may $
#
# Memcached Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800714);
  script_version("$Revision: 1.0 $");
  script_name(english:"Memcached Version Detection");
  desc["english"] = "

  Overview: The script detects the installed version of memcached and sets
  the result into KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set Version of MemcacheDB in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_dependencies("find_service.nes");
  script_family(english:"Service detection");
  exit(0);
}


# Port used by Memcached Daemon
memcachedPort = 11211;
if(!get_port_state(memcachedPort)){
  exit(0);
}

data = string("version \r\n");
appsock = open_sock_tcp(memcachedPort);
if(appsock)
{
  send(socket:appsock, data:data);
  response = recv(socket:appsock, length:1024);
  close(appsock);
  if(response != NULL)
  {
    version = eregmatch(pattern:"VERSION ([0-9.]+)", string:response);
    if(version[1] != NULL){
      set_kb_item(name:"MemCached/Ver", value:version[1]);
    }
  }
}
