###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms08-031.nasl 0289 29 11:44:09Z sep $
#
# Cumulative Security Update for Internet Explorer (950759)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800103);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2008-1442","CVE-2008-1544");
  script_bugtraq_id(28379, 29556);
  script_xref(name:"CB-A", value:"08-0096");
  script_name(english:"Cumulative Security Update for Internet Explorer (950759)");
  desc["english"] = "

  Overview : This host has Microsoft Internet Explorer installed, which is
  prone to HTTP request splitting/smuggling and HTML Objects Memory Corruption
  Vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to,
  - a memory corruption error while processing a Web page that contains certain
    unexpected method calls to HTML objects.
  - failure of setRequestHeader method of the XMLHttpRequest object to block
    dangerous HTTP request headers when certain 8-bit character sequences are
    appended to a header name.

  Impact:
  Successful exploitation allow remote attackers to execute arbitrary
  code by tricking user into visiting a specially crafted web page and to read
  data from a Web page in another domain in Internet Explorer. Attackers can
  use above issues to poison web caches, steal credentials, launch cross-site
  scripting, HTML-injection, and session-hijacking attacks.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Internet Explorer 5.01 & 6 SP1 for Microsoft Windows 2000
  Microsoft Internet Explorer 6 for Microsoft Windows 2003 and XP
  Microsoft Internet Explorer 7 for Microsoft Windows 2003 and XP

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms08-031.mspx

  References:
  http://secunia.com/advisories/30575
  http://secunia.com/advisories/29453
  http://www.frsirt.com/english/advisories/2008/0980
  http://www.frsirt.com/english/advisories/2008/1778
  http://www.microsoft.com/technet/security/bulletin/ms08-031.mspx

  CVSS Score :
    CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 6.1
  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");
include("secpod_ie_supersede.inc");

# Check the hotfix applicability to each OS
if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}


function Get_FileVersion()
{
  sysFile = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                            item:"Install Path");
  if(!sysFile){
    exit(0);
  }

  sysFile += "\mshtml.dll";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysFile);
  file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:sysFile);

  soc = open_sock_tcp(port);
  if(!soc){
    exit(0);
  }

  r = smb_session_request(soc:soc, remote:name);
  if(!r)
  {
    close(soc);
    exit(0);
  }

  prot = smb_neg_prot(soc:soc);
  if(!prot)
  {
    close(soc);
    exit(0);
  }

  r = smb_session_setup(soc:soc, login:login, password:pass,
                        domain:domain, prot:prot);
  if(!r)
  {
    close(soc);
    exit(0);
  }

  uid = session_extract_uid(reply:r);
  r = smb_tconx(soc:soc, name:name, uid:uid, share:share);

  tid = tconx_extract_tid(reply:r);
  if(!tid)
  {
    close(soc);
    exit(0);
  }

  fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
  if(!fid)
  {
    close(soc);
    exit(0);
  }

  v = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod",
                 offset:2000000);
  close(soc);
  return v;
}

ieVer = registry_get_sz(key:"SOFTWARE\Microsoft\Internet Explorer",
                        item:"Version");
if(!ieVer){
  ieVer = registry_get_sz(item:"IE",
                   key:"SOFTWARE\Microsoft\Internet Explorer\Version Vector");
}

if(!ieVer){
  exit(0);
}

# Supersede check for MS08-045 and later
if(ie_latest_hotfix_update(bulletin:"MS08-031")){
  exit(0);
}

# MS08-031 Hotfix check
if(hotfix_missing(name:"950759") == 0){
  exit(0);
}

vers = Get_FileVersion();
if(vers == NULL){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for IE version 5
  if(ereg(pattern:"^5\..*", string:ieVer))
  {
    if(ereg(pattern:"(5\.00\.(([0-2]?[0-9]?[0-9]?[0-9]|3?([0-7][0-9][0-9]" +
                    "|8([0-5][0-9]|6[0-3])))(\..*)|3864\.(0?[0-9]?[0-9]?"  +
                    "[0-9]|1[0-7][0-9][0-9])))$", string:vers)){
      security_hole(get_kb_item("SMB/transport"));
    }
    exit(0);
  }

  # Check for IE version 6
  if(ereg(pattern:"^6\..*", string:ieVer))
  {
    if(ereg(pattern:"(6\.00\.(([01]?[0-9]?[0-9]?[0-9]|2([0-7][0-9][0-9]" +
                    "))(\..*)|2800\.(0?[0-9]?[0-9]?[0-9]|1([0-5][0-9]" +
                    "[0-9]|6(0[0-9]|10)))))$", string:vers)){
      security_hole(get_kb_item("SMB/transport"));
    }
    exit(0);
  }
}

if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  #Check for IE version 6
  if(ereg(pattern:"^6\..*", string:ieVer))
  {
    if("Service Pack 2" >< SP)
    {
      if(ereg(pattern:"(6\.00\.(([01]?[0-9]?[0-9]?[0-9]|2([0-8][0-9]" +
                      "[0-9]))(\..*)|2900\.([0-2]?[0-9]?[0-9]?[0-9]|3(" +
                      "[0-2][0-9][0-9]|3([0-4][0-9]|5[0-3])))))$",
              string:vers)){
        security_hole(get_kb_item("SMB/transport"));
      }
      exit(0);
    }
    if("Service Pack 3" >< SP)
    {
      if(ereg(pattern:"(6\.00\.(([01]?[0-9?[0-9]?[0-9]|2[0-8][0-9][0-9]" +
                      ")(\..*)|2900\.([0-4]?[0-9]?[0-9]?[0-9]|5([0-4]" +
                      "[0-9][0-9]|5([0-7][0-9]|8[0-2])))))$",
              string:vers)){
        security_hole(get_kb_item("SMB/transport"));
      }
      exit(0);
    }
  }

  # Check for IE version 7
  if(ereg(pattern:"^7\..*", string:ieVer))
  {
    if(ereg(pattern:"(7\.00\.([0-5]?[0-9]?[0-9]?[0-9]\..*|6000\.(0?[0-9]?" +
                    "[0-9]?[0-9]?[0-9]|1([0-5][0-9][0-9][0-9]|6([0-5]" +
                    "[0-9][0-9]|6([0-6][0-9]|7[0-3]))))))$",
            string:vers)){
      security_hole(get_kb_item("SMB/transport"));
    }
    exit(0);
  }
}

if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  #Check for IE version 6
  if(ereg(pattern:"^6\..*", string:ieVer))
  {
    if("Service Pack 2" >< SP)
    {
      if(ereg(pattern:"(6\.00\.(([0-2]?[0-9]?[0-9][0-9]|3([0-6][0-9][0-9]" +
                      "|7[0-8][0-9]))(\..*)|3790\.([0-3]?[0-9]?[0-9]?[0-9]" +
                      "|4([01][0-9][0-9]|2([0-6][0-9]|7[0-4])))))$",
              string:vers)){
        security_hole(get_kb_item("SMB/transport"));
      }
      exit(0);
    }
    if("Service Pack 1" >< SP)
    {
      if(ereg(pattern:"(6\.00\.(([0-2]?[0-9]?[0-9]?[0-9]|3([0-6][0-9]" +
                       "[0-9]|7[0-8][0-9]))(\..*)|3790\.([0-2]?[0-9]?" +
                       "[0-9]?[0-9]|3(0[0-9][0-9]|1([01][0-9]|2[0-2]" +
                       ")))))$", string:vers)){
         security_hole(get_kb_item("SMB/transport"));
      }
      exit(0);
    }
  }

  #Check for IE version 7
  if(ereg(pattern:"^7\..*", string:ieVer))
  {
    if(ereg(pattern:"(7\.00\.([0-5]?[0-9]?[0-9]?[0-9]\..*|6000\.(0?[0-9]?" +
                    "[0-9]?[0-9]?[0-9]|1([0-5][0-9][0-9][0-9]|6([0-5]" +
                    "[0-9][0-9]|6([0-6][0-9]|7[0-3]))))))$",
            string:vers)){
      security_hole(get_kb_item("SMB/transport"));
    }
    exit(0);
  }
}
