###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opera_mime_dos_vuln_win.nasl 668 2008-12-15 10:42:39Z dec $
#
# Opera Web Browser DoS attacks on MIME via malformed MIME emails (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800081);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5428");
  script_name(english:"Opera Web Browser DoS attacks on MIME via malformed MIME emails (Win)");
  desc["english"] = "

  Overview: The host is installed with Opera Web Browser and is prone to
  denial of service vulnerability.

  Vulnerability Insight:
  Flaw is caused due to improper handling of multipart/mixed e-mail messages
  with many MIME parts and e-mail messages with many Content-type: message/rfc822
  headers.

  Impact:
  Successful exploitation could result in web browser crash.

  Impact Level: Application

  Affected Software/OS:
  Opera version 9.51 on Windows.

  Fix: Upgrade to higher version of Opera
  http://www.opera.com/download/

  References:
  http://mime.recurity.com/cgi-bin/twiki/view/Main/AttackIntro

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  exit(0);
}


if(get_kb_item("Opera/Win/Version") =~ "9.51"){
  security_warning(0);
}
