###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_samba_detect.nasl 819 2009-01-08 17:20:10Z jan $
#
# Samba Version Detection
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Modified by: Sujit Ghosal (sghosal@secpod.com)
# Date: 8th May 2009
# Changes: Changed the command from smbd to smbclient and Modified Regex
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(800403);
  script_version("$Revision: 1.0 $");
  script_name(english:"Samba Version Detection");
  desc["english"] = "

  Overview: The script detects the version of Samba and sets the value in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set the KB for the version of Samba");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

smbName = find_file(file_name:"smbd", file_path:"/", useregex:TRUE,
                    regexpar:"$", sock:sock);
foreach binaryName (smbName)
{
  binaryName = chomp(binaryName);
  smbVer = get_bin_version(full_prog_name:binaryName, version_argv:"-V",
                           ver_pattern:"Version (.*)", sock:sock);
  smbVer = split(smbVer[1], "\n", keep:0);
  if(smbVer[0] != NULL)
  {
    set_kb_item(name:"Samba/Version", value:smbVer[0]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
