###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for acroread SUSE-SA:2007:011
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850062);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-011");
  script_cve_id("CVE-2006-5857", "CVE-2007-0044", "CVE-2007-0045", "CVE-2007-0046", "CVE-2007-0047", "CVE-2007-0048");
  script_name(english: "SuSE Update for acroread SUSE-SA:2007:011");
  desc["english"] = "

  Vulnerability Insight:

  The Adobe Acrobat Reader has been updated to version 7.0.9.

  This update also includes following security fixes:

  CVE-2006-5857: A memory corruption problem was fixed in Adobe Acrobat
  Reader can potentially lead to code execution.

  CVE-2007-0044: Universal Cross Site Request Forgery (CSRF) problems
  were fixed in the Acrobat Reader plugin which could be
  exploited by remote attackers to conduct CSRF attacks
  using any site that is providing PDFs.

  CVE-2007-0045: Cross site scripting problems in the Acrobat Reader
  plugin were fixed, which could be exploited by remote
  attackers to conduct XSS attacks against any site that
  is providing PDFs.

  CVE-2007-0046: A double free problem in the Acrobat Reader plugin was fixed
  which could be used by remote attackers to potentially execute
  arbitrary code.
  Note that all platforms using Adobe Reader currently have
  counter measures against such attack where it will just
  cause a controlled abort().

  CVE-2007-0048 affect only Microsoft Windows and
  Internet Explorer.

  Please note that the Acrobat Reader on SUSE Linux Enterprise Server
  9 is affected too, but can not be updated currently due to GTK+
  2.4 requirements.  We are trying to find a solution.

  Acrobat Reader on SUSE Linux Enterprise Server 8 and SUSE Linux
  Desktop 1 is no longer supported and should be deinstalled.

  Impact:
  remote code execution

  Affected Software/OS:
  acroread on SUSE LINUX 10.1, openSUSE 10.2, Novell Linux Desktop 9, SUSE SLED 10

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_11_acroread.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of acroread");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "SLED10")
{

  if(isrpmvuln(pkg:"acroread", rpm:"acroread~7.0.9~1.2", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"acroread", rpm:"acroread~7.0.9~2.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"acroread", rpm:"acroread~7.0.9~2.1", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"acroread", rpm:"acroread~7.0.9~1.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}