###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for libexif SUSE-SA:2007:039
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850103);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-039");
  script_cve_id("CVE-2006-4168", "CVE-2007-2645");
  script_name(english: "SuSE Update for libexif SUSE-SA:2007:039");
  desc["english"] = "

  Vulnerability Insight:

  Two security problems were fixed in the libexif library which handles
  extended information in JPEG images.

  CVE-2007-2645: A denial of service problem (crash) was fixed in the
  EXIF Loader of libexif, which could be used to crash the browser
  or image viewer when it interprets the EXIF tags in prepared JPEG
  files. ()

  CVE-2006-4168: A integer overflow was fixed in the EXIF loader, which
  could potentially be used to execute code or at least to crash the
  image viewer/web browser.

  Attackers might crash your E-Mail client or Web browser by embedding
  a crafted JPEG image with broken EXIF data.

  Impact:
  remote denial of service

  Affected Software/OS:
  libexif on SUSE LINUX 10.1, openSUSE 10.2, SuSE Linux Enterprise Server 8, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SLE SDK 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_39_libexif.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libexif");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.6.14~20", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libexif5", rpm:"libexif5~0.5.12~39", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libexif-32bit", rpm:"libexif-32bit~0.6.14~20", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.5.12~118.10", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.5.3~114", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"libexif5", rpm:"libexif5~0.5.12~17.7", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.5.12~118.10", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.5.3~114", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.5.12~118.10", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.5.3~114", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"libexif5", rpm:"libexif5~0.5.12~17.7", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.6.13~20.6", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.5.12~118.10", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.5.3~114", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.6.13~20.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.6.13~20.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libexif5", rpm:"libexif5~0.5.12~17.7", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.5.12~118.10", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.5.3~114", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}