###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for evolution,evolution-data-server SUSE-SA:2007:042
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850060);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-042");
  script_cve_id("CVE-2007-3257");
  script_name(english: "SuSE Update for evolution,evolution-data-server SUSE-SA:2007:042");
  desc["english"] = "

  Vulnerability Insight:

  A malicious IMAP server could execute code within evolution by sending
  a malformed response to a SEQUENCE command. CVE-2007-3257

  This requires the user to connect to this malicious server (or a DNS
  entry of a good one replaced pointed to a malicious one)

  For older products the problematic code lives in the evolution package,
  for newer ones in the evolution-data-server package.

  Impact:
  remote code execution

  Affected Software/OS:
  evolution,evolution-data-server on SUSE LINUX 10.1, openSUSE 10.2, Novell Linux Desktop 9, SUSE Linux Enterprise Desktop 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_42_evolution.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of evolution,evolution-data-server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~1.8.2~11", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-data-server-devel", rpm:"evolution-data-server-devel~1.8.2~11", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-data-server-32bit", rpm:"evolution-data-server-32bit~1.8.2~11", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~1.6.0~43.58", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-data-server-32bit", rpm:"evolution-data-server-32bit~1.6.0~43.58", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-data-server-devel", rpm:"evolution-data-server-devel~1.6.0~43.58", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.0.4~0.8", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.0.4~0.8", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.0.4~0.8", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~1.2.3~164", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~1.6.0~43.58", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-data-server-32bit", rpm:"evolution-data-server-32bit~1.6.0~43.58", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-data-server-devel", rpm:"evolution-data-server-devel~1.6.0~43.58", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~1.6.0~43.58", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-data-server-devel", rpm:"evolution-data-server-devel~1.6.0~43.58", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}