###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for kernel-rt SUSE-SA:2008:013
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850028);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-013");
  script_cve_id("CVE-2007-5500", "CVE-2007-5501", "CVE-2007-5904", "CVE-2008-0001", "CVE-2008-0600");
  script_name(english: "SuSE Update for kernel-rt SUSE-SA:2008:013");
  desc["english"] = "

  Vulnerability Insight:

  The Linux kernel in the SUSE Linux Enterprise Realtime 10 SP1 product
  was updated to fix the following security problems. Our other products have
  already received those fixes.

  - CVE-2008-0001: Incorrect access mode checks could be used by local
  attackers to corrupt directory contents and so cause denial of
  service attacks or potentially execute code.

  - CVE-2008-0600: A local privilege escalation was found in
  the vmsplice_pipe system call, which could be used by local attackers
  to gain root access.

  - CVE-2007-5500: A buggy condition in the ptrace attach logic can
  be used by local attackers to hang the machine.

  - CVE-2007-5501: The tcp_sacktag_write_queue function in
  net/ipv4/tcp_input.c allows remote attackers to cause a denial
  of service (crash) via crafted ACK responses that trigger a NULL
  pointer dereference.

  - CVE-2007-5904: Multiple buffer overflows in CIFS VFS allows remote
  attackers to cause a denial of service (crash) and possibly execute
  arbitrary code via long SMB responses that trigger the overflows
  in the SendReceive function.

  This problem requires the attacker to set up a malicious Samba/CIFS
  server and getting the client to connect to it.

  No other bugs were fixed.

  Impact:
  local privilege escalation

  Affected Software/OS:
  kernel-rt on SUSE Linux Enterprise Server RT Solution 10

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_13_kernel.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel-rt");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "SLESRTSol10")
{

  if(isrpmvuln(pkg:"kernel-rt", rpm:"kernel-rt~2.6.22.10~3.8.2", rls:"SLESRTSol10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-rt_shield_trace", rpm:"kernel-rt_shield_trace~2.6.22.10~3.8.2", rls:"SLESRTSol10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-rt_timing", rpm:"kernel-rt_timing~2.6.22.10~3.8.2", rls:"SLESRTSol10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.22.10~3.8.2", rls:"SLESRTSol10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.22.10~3.8.2", rls:"SLESRTSol10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-rt_bigsmp", rpm:"kernel-rt_bigsmp~2.6.22.10~3.8.2", rls:"SLESRTSol10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-rt_bigsmp_shield_trace", rpm:"kernel-rt_bigsmp_shield_trace~2.6.22.10~3.8.2", rls:"SLESRTSol10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}