###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for flash-player SUSE-SA:2008:022
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850000);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-022");
  script_cve_id("CVE-2007-0071", "CVE-2007-5275", "CVE-2007-6019", "CVE-2007-6243", "CVE-2007-6637", "CVE-2008-1654", "CVE-2008-1655");
  script_name(english: "SuSE Update for flash-player SUSE-SA:2008:022");
  desc["english"] = "

  Vulnerability Insight:

  The Adobe Flash Player was updated to version 9.0.124.0 to fix several
  security problems.

  In the worst case an attacker could potentially have flash-player
  execute arbitrary code via specially crafted files, for instance
  embedded in web pages.

  Impact:
  remote code execution

  Affected Software/OS:
  flash-player on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, Novell Linux Desktop 9, SUSE Linux Enterprise Desktop 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_22_flashplayer.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of flash-player");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~9.0.124.0~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~9.0.124.0~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~9.0.124.0~0.1", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~9.0.124.0~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~9.0.124.0~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}