###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for clamav SUSE-SA:2008:024
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850043);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-024");
  script_cve_id("CVE-2007-6595", "CVE-2007-6596", "CVE-2008-0314", "CVE-2008-1100", "CVE-2008-1387", "CVE-2008-1833", "CVE-2008-1835", "CVE-2008-1836", "CVE-2008-1837");
  script_name(english: "SuSE Update for clamav SUSE-SA:2008:024");
  desc["english"] = "

  Vulnerability Insight:

  The AntiVirus scan engine ClamAV was updated to version 0.93 fixes a long list of
  vulnerabilities.

  These vulnerabilities can lead to remote code execution, bypassing
  the scanning engine, remote denial-of-service, local file overwrite.
  CVE-2008-1835,
  CVE-2008-1100,
  CVE-2007-6596

  Since the library changed, we also released updated klamav packages
  for openSUSE 10.2 and 10.3.

  Impact:
  remote code execution

  Affected Software/OS:
  clamav on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, SUSE SLES 9, Open Enterprise Server, Novell Linux POS 9, SLE SDK 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_24_clamav.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of clamav");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"klamav", rpm:"klamav~0.41.1~32.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.93~0.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.93~0.3", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.93~0.3", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.93~0.3", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"klamav", rpm:"klamav~0.41.1~17.4", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.93~0.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.93~0.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}