##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_trillian_detect.nasl 1348 2009-04-01 14:01:24Z apr $
#
# Trillian Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http//intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800264);
  script_version("$Revision: 1.0 $");
  script_name(english:"Trillian Version Detection");
  desc["english"] = "
  Overview : This script finds the installed Trillian and saves the
  result in KB item.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set Version of Trillian in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Clients\IM\Trillian";
regKey = registry_key_exists(key:key);
if(!regKey){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Trillian";
exePath = registry_get_sz(key:key, item:"DisplayIcon");
dllFile = exePath - "trillian.exe" + "toolkit.dll";
if(dllFile != NULL)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllFile);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllFile);
  triVer = GetVer(file:file, share:share);
  set_kb_item(name:"Trillian/Ver", value:triVer);
}
