###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for linux-source-2.6.12/2.6.15/2.6.17 vulnerabilities USN-416-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840099);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "416-1");
  script_cve_id("CVE-2006-4572", "CVE-2006-4814", "CVE-2006-5749", "CVE-2006-5753", "CVE-2006-5755", "CVE-2006-5757", "CVE-2006-5823", "CVE-2006-6053", "CVE-2006-6054", "CVE-2006-6056", "CVE-2006-6057", "CVE-2006-6106");
  script_name(english: "Ubuntu Update for linux-source-2.6.12/2.6.15/2.6.17 vulnerabilities USN-416-1");
  desc["english"] = "

  Vulnerability Insight:

  Mark Dowd discovered that the netfilter iptables module did not
  correcly handle fragmented IPv6 packets. By sending specially crafted
  packets, a remote attacker could exploit this to bypass firewall
  rules. This has has already been fixed for Ubuntu 6.10 in USN-395-1;
  this is the corresponding fix for Ubuntu 6.06.(CVE-2006-4572)
  
  Doug Chapman discovered an improper lock handling in the mincore()
  function. A local attacker could exploit this to cause an eternal hang
  in the kernel, rendering the machine unusable. (CVE-2006-4814)
  
  Al Viro reported that the ISDN PPP module did not initialize the reset
  state timer. By sending specially crafted ISDN packets, a remote
  attacker could exploit this to crash the kernel. (CVE-2006-5749)
  
  Various syscalls (like listxattr()) misinterpreted the return value of
  return_EIO() when encountering bad inodes. By issuing particular
  system calls on a malformed file system, a local attacker could
  exploit this to crash the kernel. (CVE-2006-5753)
  
  The task switching code did not save and restore EFLAGS of processes.
  By starting a specially crafted executable, a local attacker could
  exploit this to eventually crash many other running processes. This
  only affects the amd64 platform. (CVE-2006-5755)
  
  A race condition was found in the grow_buffers() function. By mounting
  a specially crafted ISO9660 or NTFS file system, a local attacker
  could exploit this to trigger an infinite loop in the kernel,
  rendering the machine unusable. (CVE-2006-5757)
  
  A buffer overread was found in the zlib_inflate() function. By
  tricking an user into mounting a specially crafted file system which
  uses zlib compression (such as cramfs), this could be exploited to
  crash the kernel. (CVE-2006-5823)
  
  The ext3 file system driver did not properly handle corrupted data
  structures. By mounting a specially crafted ext3 file system, a local
  attacker could exploit this to crash the kernel. (CVE-2006-6053)
  
  The ext2 file system driver did not properly handle corrupted data
  structures. By mounting a specially crafted ext2 file system, a local
  attacker could exploit this to crash the kernel. (CVE-2006-6054)
  
  The hfs file system driver did not properly handle corrupted data
  structures. By mounting a specially crafted hfs file system, a local
  attacker could exploit this to crash the kernel. This only affects
  systems which enable SELinux (Ubuntu disables SELinux by default).
  (CVE-2006-6056)
  
  Several vulnerabilities have been found in the GFS2 ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  linux-source-2.6.12/2.6.15/2.6.17 vulnerabilities on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-February/000483.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of linux-source-2.6.12/2.6.15/2.6.17 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-28-386_2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-28-686_2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-28-k7_2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-28-server-bigiron_2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-28-server_2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-28_2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-28-386_2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-28-686_2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-28-k7_2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-28-server-bigiron_2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-28-server_2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avm-fritz-firmware", ver:"2.6.15-28_3.11+2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avm-fritz-kernel-source", ver:"3.11+2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-control", ver:"8.25.18+2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-kernel-source", ver:"8.25.18+2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.15-28-386_2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.15-28-686_2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.15-28-k7_2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-dev", ver:"1.0.8776+2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy-dev", ver:"1.0.7174+2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy", ver:"1.0.7174+2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx", ver:"1.0.8776+2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-kernel-source", ver:"1.0.8776+2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-legacy-kernel-source", ver:"1.0.7174+2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx-dev", ver:"7.0.0-8.25.18+2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx", ver:"7.0.0-8.25.18+2.6.15.12-28.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avm-fritz-firmware", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-386", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-686-smp", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-686", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-386", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-686", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-k7", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-server-bigiron", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-server", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-386", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-686", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-k7", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-server-bigiron", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-server", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-k7-smp", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-k7", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules-386", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules-686", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules-k7", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-server-bigiron", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-server", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.15_2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.15_2.6.15-28.51", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.15.26", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.17-11-386_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.17-11-generic_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.17-11-server-bigiron_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.17-11-server_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.17-11_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.17-11-386_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.17-11-generic_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.17-11-server-bigiron_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.17-11-server_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.17-11-386_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.17-11-generic_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.17-11-server-bigiron_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.17-11-server_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-kdump", ver:"2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avm-fritz-firmware", ver:"2.6.17-11_3.11+2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avm-fritz-firmware", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avm-fritz-kernel-source", ver:"3.11+2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-control", ver:"8.28.8+2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-kernel-source", ver:"8.28.8+2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-386", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-686-smp", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-686", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-generic", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-386", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-686", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-generic", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-k7", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-server-bigiron", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-server", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-386", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-686", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-generic", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-k7", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-server-bigiron", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-server", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-k7-smp", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-k7", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.17-11-386_2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.17-11-generic_2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules-386", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules-686", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules-generic", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules-k7", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-server-bigiron", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-server", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-dev", ver:"1.0.8776+2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy-dev", ver:"1.0.7184+2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy", ver:"1.0.7184+2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx", ver:"1.0.8776+2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-kernel-source", ver:"1.0.8776+2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-legacy-kernel-source", ver:"1.0.7184+2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"vmware-player-kernel-modules", ver:"2.6.17-11_2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"vmware-player-kernel-modules", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx-dev", ver:"7.1.0-8.28.8+2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx", ver:"7.1.0-8.28.8+2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.17_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.17_2.6.17.1-11.35", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules-common", ver:"2.6.17.7-11.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.17.11", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.12-10-386_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.12-10-686-smp_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.12-10-686_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.12-10-k7-smp_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.12-10-k7_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.12-10_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.12-10-386_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.12-10-686-smp_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.12-10-686_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.12-10-k7-smp_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.12-10-k7_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-patch-ubuntu", ver:"2.6.12_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.12_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.12_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-tree", ver:"2.6.12_2.6.12-10.45", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}