###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for moin, moin1.3 vulnerabilities USN-423-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840156);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "423-1");
  script_cve_id("CVE-2007-0901", "CVE-2007-0902");
  script_name(english: "Ubuntu Update for moin, moin1.3 vulnerabilities USN-423-1");
  desc["english"] = "

  Vulnerability Insight:

  A flaw was discovered in MoinMoin's debug reporting sanitizer which
  could lead to a cross-site scripting attack.  By tricking a user into
  viewing a crafted MoinMoin URL, an attacker could execute arbitrary
  JavaScript as the current MoinMoin user, possibly exposing the user's
  authentication information for the domain where MoinMoin was hosted.
  Only Ubuntu Breezy was vulnerable.  (CVE-2007-0901)
  
  An information leak was discovered in MoinMoin's debug reporting, which
  could expose information about the versions of software running on the
  host system.  MoinMoin administrators can add &quot;show_traceback=0&quot; to
  their site configurations to disable debug tracebacks.  (CVE-2007-0902)

  Affected Software/OS:
  moin, moin1.3 vulnerabilities on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-February/000486.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of moin, moin1.3 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"moinmoin-common", ver:"1.5.2-1ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-moinmoin", ver:"1.5.2-1ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-moinmoin", ver:"1.5.2-1ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"moinmoin-common", ver:"1.5.3-1ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-moinmoin", ver:"1.5.3-1ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-moinmoin", ver:"1.5.3-1ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"moin", ver:"1.2.4-1ubuntu2.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"moinmoin-common", ver:"1.3.4-6ubuntu1.5.10", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-moinmoin", ver:"1.3.4-6ubuntu1.5.10", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.3-moinmoin", ver:"1.3.4-6ubuntu1.5.10", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-moinmoin", ver:"1.3.4-6ubuntu1.5.10", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}