###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for linux-source-2.6.15 vulnerabilities USN-508-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840017);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "508-1");
  script_cve_id("CVE-2005-0504", "CVE-2007-2242", "CVE-2007-3104", "CVE-2007-3105", "CVE-2007-3848", "CVE-2007-4308");
  script_name(english: "Ubuntu Update for linux-source-2.6.15 vulnerabilities USN-508-1");
  desc["english"] = "

  Vulnerability Insight:

  A buffer overflow was discovered in the Moxa serial driver.  Local
  attackers could execute arbitrary code and gain root privileges.
  (CVE-2005-0504)
  
  A flaw was discovered in the IPv6 stack's handling of type 0 route headers.
  By sending a specially crafted IPv6 packet, a remote attacker could cause
  a denial of service between two IPv6 hosts. (CVE-2007-2242)
  
  A flaw in the sysfs_readdir function allowed a local user to cause a
  denial of service by dereferencing a NULL pointer. (CVE-2007-3104)
  
  A buffer overflow was discovered in the random number generator.  In
  environments with granular assignment of root privileges, a local attacker
  could gain additional privileges. (CVE-2007-3105)
  
  It was discovered that certain setuid-root processes did not correctly
  reset process death signal handlers.  A local user could manipulate this
  to send signals to processes they would not normally have access to.
  (CVE-2007-3848)
  
  It was discovered that the aacraid SCSI driver did not correctly check
  permissions on certain ioctls.  A local attacker could cause a denial
  of service or gain privileges. (CVE-2007-4308)

  Affected Software/OS:
  linux-source-2.6.15 vulnerabilities on Ubuntu 6.06 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-August/000585.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of linux-source-2.6.15 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-29-386_2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-29-686_2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-29-k7_2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-29-server-bigiron_2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-29-server_2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-29_2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-29-386_2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-29-686_2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-29-k7_2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-29-server-bigiron_2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-29-server_2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.15_2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.15_2.6.15-29.58", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}