###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for pwlib vulnerability USN-561-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840204);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "561-1");
  script_cve_id("CVE-2007-4897");
  script_name(english: "Ubuntu Update for pwlib vulnerability USN-561-1");
  desc["english"] = "

  Vulnerability Insight:

  Jose Miguel Esparza discovered that pwlib did not correctly handle large
  string lengths.  A remote attacker could send specially crafted packets to
  applications linked against pwlib (e.g. Ekiga) causing them to crash, leading
  to a denial of service.

  Affected Software/OS:
  pwlib vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-January/000647.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pwlib vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libpt", ver:"1.10.0_1.10.3-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-dbg", ver:"1.10.3-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-dev", ver:"1.10.3-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-alsa", ver:"1.10.3-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-v4l2", ver:"1.10.3-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-v4l", ver:"1.10.3-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-avc", ver:"1.10.3-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-dc", ver:"1.10.3-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-oss", ver:"1.10.3-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-doc", ver:"1.10.3-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libpt", ver:"1.10.0_1.10.0-1ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-dbg", ver:"1.10.0-1ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-dev", ver:"1.10.0-1ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-alsa", ver:"1.10.0-1ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-v4l2", ver:"1.10.0-1ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-v4l", ver:"1.10.0-1ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-avc", ver:"1.10.0-1ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-dc", ver:"1.10.0-1ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-oss", ver:"1.10.0-1ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-doc", ver:"1.10.0-1ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libpt", ver:"1.10.0_1.10.2.dfsg-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-dbg", ver:"1.10.2.dfsg-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-dev", ver:"1.10.2.dfsg-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-alsa", ver:"1.10.2.dfsg-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-v4l2", ver:"1.10.2.dfsg-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-v4l", ver:"1.10.2.dfsg-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-avc", ver:"1.10.2.dfsg-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-dc", ver:"1.10.2.dfsg-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-oss", ver:"1.10.2.dfsg-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-doc", ver:"1.10.2.dfsg-0ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libpt", ver:"1.10.0_1.10.10-0ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-dbg", ver:"1.10.10-0ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-dev", ver:"1.10.10-0ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-alsa", ver:"1.10.10-0ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-v4l2", ver:"1.10.10-0ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-v4l", ver:"1.10.10-0ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-avc", ver:"1.10.10-0ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-dc", ver:"1.10.10-0ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-plugins-oss", ver:"1.10.10-0ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpt-doc", ver:"1.10.10-0ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}