###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for pulseaudio vulnerability USN-573-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840337);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "573-1");
  script_cve_id("CVE-2008-0008");
  script_name(english: "Ubuntu Update for pulseaudio vulnerability USN-573-1");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that PulseAudio did not properly drop privileges
  when running as a daemon. Local users may be able to exploit this
  and gain privileges. The default Ubuntu configuration is not
  affected.

  Affected Software/OS:
  pulseaudio vulnerability on Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-January/000660.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pulseaudio vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libpulse-browse0", ver:"0.9.5-5ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpulse-dev", ver:"0.9.5-5ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpulse-mainloop-glib0", ver:"0.9.5-5ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpulse0", ver:"0.9.5-5ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-esound-compat", ver:"0.9.5-5ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio", ver:"0.9.5-5ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-gconf", ver:"0.9.5-5ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-hal", ver:"0.9.5-5ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-lirc", ver:"0.9.5-5ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-x11", ver:"0.9.5-5ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-zeroconf", ver:"0.9.5-5ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-utils", ver:"0.9.5-5ubuntu4.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libpulse-browse0", ver:"0.9.6-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpulse-dev", ver:"0.9.6-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpulse-mainloop-glib0", ver:"0.9.6-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpulse0", ver:"0.9.6-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-esound-compat", ver:"0.9.6-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio", ver:"0.9.6-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-gconf", ver:"0.9.6-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-hal", ver:"0.9.6-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-lirc", ver:"0.9.6-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-x11", ver:"0.9.6-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-zeroconf", ver:"0.9.6-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-utils", ver:"0.9.6-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}