###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for krb5 vulnerabilities USN-587-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840334);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "587-1");
  script_cve_id("CVE-2008-0062", "CVE-2008-0063", "CVE-2008-0947");
  script_name(english: "Ubuntu Update for krb5 vulnerabilities USN-587-1");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that krb5 did not correctly handle certain krb4
  requests.  An unauthenticated remote attacker could exploit this flaw
  by sending a specially crafted traffic, which could expose sensitive
  information, cause a crash, or execute arbitrary code. (CVE-2008-0062,
  CVE-2008-0063)
  
  A flaw was discovered in the kadmind service's handling of file
  descriptors.  An unauthenticated remote attacker could send specially
  crafted requests that would cause a crash, resulting in a denial of
  service.  Only systems with configurations allowing large numbers of
  open file descriptors were vulnerable. (CVE-2008-0947)

  Affected Software/OS:
  krb5 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-March/000675.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of krb5 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libkadm55", ver:"1.4.4-5ubuntu3.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dbg", ver:"1.4.4-5ubuntu3.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.4.4-5ubuntu3.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb53", ver:"1.4.4-5ubuntu3.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.4.4-5ubuntu3.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-clients", ver:"1.4.4-5ubuntu3.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.4.4-5ubuntu3.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.4.4-5ubuntu3.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.4.4-5ubuntu3.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.4.4-5ubuntu3.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-user", ver:"1.4.4-5ubuntu3.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-doc", ver:"1.4.4-5ubuntu3.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libkadm55", ver:"1.4.3-5ubuntu0.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.4.3-5ubuntu0.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb53", ver:"1.4.3-5ubuntu0.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.4.3-5ubuntu0.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-clients", ver:"1.4.3-5ubuntu0.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.4.3-5ubuntu0.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.4.3-5ubuntu0.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.4.3-5ubuntu0.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.4.3-5ubuntu0.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-user", ver:"1.4.3-5ubuntu0.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-doc", ver:"1.4.3-5ubuntu0.7", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libkadm55", ver:"1.4.3-9ubuntu1.6", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dbg", ver:"1.4.3-9ubuntu1.6", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.4.3-9ubuntu1.6", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb53", ver:"1.4.3-9ubuntu1.6", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.4.3-9ubuntu1.6", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-clients", ver:"1.4.3-9ubuntu1.6", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.4.3-9ubuntu1.6", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.4.3-9ubuntu1.6", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.4.3-9ubuntu1.6", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.4.3-9ubuntu1.6", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-user", ver:"1.4.3-9ubuntu1.6", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-doc", ver:"1.4.3-9ubuntu1.6", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libkadm55", ver:"1.6.dfsg.1-7ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dbg", ver:"1.6.dfsg.1-7ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.6.dfsg.1-7ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb53", ver:"1.6.dfsg.1-7ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.6.dfsg.1-7ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-clients", ver:"1.6.dfsg.1-7ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.6.dfsg.1-7ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.6.dfsg.1-7ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.6.dfsg.1-7ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.6.dfsg.1-7ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-user", ver:"1.6.dfsg.1-7ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-doc", ver:"1.6.dfsg.1-7ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}