###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for pidgin vulnerabilities USN-675-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840284);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "675-1");
  script_cve_id("CVE-2008-2927", "CVE-2008-2955", "CVE-2008-2957", "CVE-2008-3532");
  script_name(english: "Ubuntu Update for pidgin vulnerabilities USN-675-1");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that Pidgin did not properly handle certain malformed
  messages in the MSN protocol handler. A remote attacker could send a specially
  crafted message and possibly execute arbitrary code with user privileges.
  (CVE-2008-2927)
  
  It was discovered that Pidgin did not properly handle file transfers containing
  a long filename and special characters in the MSN protocol handler. A remote
  attacker could send a specially crafted filename in a file transfer request
  and cause Pidgin to crash, leading to a denial of service. (CVE-2008-2955)
  
  It was discovered that Pidgin did not impose resource limitations in the UPnP
  service. A remote attacker could cause Pidgin to download arbitrary files
  and cause a denial of service from memory or disk space exhaustion.
  (CVE-2008-2957)
  
  It was discovered that Pidgin did not validate SSL certificates when using a
  secure connection. If a remote attacker were able to perform a
  man-in-the-middle attack, this flaw could be exploited to view sensitive
  information. This update alters Pidgin behaviour by asking users to confirm
  the validity of a certificate upon initial login. (CVE-2008-3532)

  Affected Software/OS:
  pidgin vulnerabilities on Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000784.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pidgin vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"finch", ver:"2.4.1-1ubuntu2.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple0", ver:"2.4.1-1ubuntu2.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.4.1-1ubuntu2.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin", ver:"2.4.1-1ubuntu2.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"finch-dev", ver:"2.4.1-1ubuntu2.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.4.1-1ubuntu2.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.4.1-1ubuntu2.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-data", ver:"2.4.1-1ubuntu2.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.4.1-1ubuntu2.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gaim", ver:"2.4.1-1ubuntu2.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"finch", ver:"2.2.1-1ubuntu4.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple0", ver:"2.2.1-1ubuntu4.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.2.1-1ubuntu4.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin", ver:"2.2.1-1ubuntu4.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"finch-dev", ver:"2.2.1-1ubuntu4.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.2.1-1ubuntu4.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.2.1-1ubuntu4.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-data", ver:"2.2.1-1ubuntu4.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.2.1-1ubuntu4.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gaim", ver:"2.2.1-1ubuntu4.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}