###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vlc_media_player_mem_crptn_vuln_lin.nasl 0341 2008-10-17 11:09:50Z oct $
#
# VLC Media Player XSPF Playlist Memory Corruption Vulnerability (Linux)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800113);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4558");
  script_bugtraq_id(31758);
  script_name(english:"VLC Media Player XSPF Playlist Memory Corruption Vulnerability (Linux)");
  desc["english"] = "

  Overview: This host is installed with VLC Media Player and is prone to
  Memory Corruption Vulnerability.

  Vulnerability Insight:
  The flaw exists due to VLC (xspf.c) library does not properly perform bounds
  checking on an identifier tag from an XSPF file before using it to index an
  array on the heap.

  Impact: Successful exploitation allows attackers to execute arbitrary code by
  tricking a user into opening a specially crafted XSPF file or even can crash
  an affected application.

  Impact Level: Application

  Affected Software/OS:
  VLC media player 0.9.2 and prior Linux.

  Fix: Upgrade to Version 0.9.3 or later,
  http://www.videolan.org/vlc/

  References:
  http://secunia.com/advisories/32267/
  http://www.frsirt.com/english/advisories/2008/2826/products
  http://www.coresecurity.com/content/vlc-xspf-memory-corruption

  CVSS Score:
    CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 6.5
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of VLC Media Player");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Denial of Service");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

vlcBinPath = find_bin(prog_name:"vlc", sock:sock);

foreach binPath (vlcBinPath)
{
  vlcVer = get_bin_version(full_prog_name:chomp(binPath), version_argv:"--version",
                           ver_pattern:"ersion ([0-9.]+[a-z]?)", sock:sock);
  if(vlcVer)
  {
    # Check for VLC Media Player Version <= 0.9.2
    if(version_is_less_equal(version:vlcVer[1] ,test_version:"0.9.2")){
      security_hole(0);
    }
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
