# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:091 (mod_perl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63769);
 script_cve_id("CVE-2009-0796");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:091 (mod_perl)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mod_perl
announced via advisory MDVSA-2009:091.

A vulnerability has been found and corrected in mod_perl v1.x and v2.x:

Cross-site scripting (XSS) vulnerability in Status.pm in Apache::Status
and Apache2::Status in mod_perl1 and mod_perl2 for the Apache HTTP
Server, when /perl-status is accessible, allows remote attackers to
inject arbitrary web script or HTML via the URI (CVE-2009-0796).

The updated packages have been patched to correct these issues.

Affected: 2008.1, 2009.0, Corporate 3.0, Corporate 4.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:091

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:091 (mod_perl)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"apache-mod_perl", rpm:"apache-mod_perl~2.0.4~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache-mod_perl-devel", rpm:"apache-mod_perl-devel~2.0.4~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache-mod_perl", rpm:"apache-mod_perl~2.0.4~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache-mod_perl-devel", rpm:"apache-mod_perl-devel~2.0.4~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-mod_perl", rpm:"apache2-mod_perl~2.0.48_1.99_11~3.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-mod_perl-devel", rpm:"apache2-mod_perl-devel~2.0.48_1.99_11~3.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache-mod_perl", rpm:"apache-mod_perl~1.3.29_1.29~3.3.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"HTML-Embperl", rpm:"HTML-Embperl~1.3.29_1.3.6~3.3.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mod_perl-common", rpm:"mod_perl-common~1.3.29_1.29~3.3.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mod_perl-devel", rpm:"mod_perl-devel~1.3.29_1.29~3.3.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache-mod_perl", rpm:"apache-mod_perl~2.0.2~8.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache-mod_perl-devel", rpm:"apache-mod_perl-devel~2.0.2~8.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
