###############################################################################
# OpenVAS Vulnerability Test
# $Id: openssh_32319_remote.nasl 3171 2009-04-23 19:21:19Z mime $
#
# OpenSSH CBC Mode Information Disclosure Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(100153);
  script_bugtraq_id(32319);
  script_copyright(english:"Copyright (C) 2009 Michael Meyer");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Misc.");
  script_name(english:"OpenSSH CBC Mode Information Disclosure Vulnerability");
  script_summary(english:"Check for vulnerable version of OpenSSH");
  desc["english"] = "

  Overview: The host is installed with OpenSSH and is prone to information
  disclosure vulnerability.

  Vulnerability Insight:
  The flaw is caused due to the improper handling of errors within an SSH session
  encrypted with a block cipher algorithm in the Cipher-Block Chaining 'CBC' mode.

  Impact:
  Successful exploits will allow attackers to obtain four bytes of plaintext from
  an encrypted session.
  
  Impact Level: Application

  Affected Software/OS:
   Versions prior to OpenSSH 5.2 are vulnerable. Various versions of SSH Tectia
   are also affected. 

  Fix: Upgrade to higher version
  http://www.openssh.com/portable.html

  References:
   http://www.securityfocus.com/bid/32319

  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_dependencies("ssh_detect.nasl");
  script_require_ports("Services/ssh", 22);
  exit(0);
}

include("backport.inc");
include("version_func.inc");

port = get_kb_item("Services/ssh");
if(!port) port = 22;

banner = get_kb_item("SSH/banner/" + port);
if ( ! banner ) exit(0);

banner = tolower(get_backport_banner(banner:banner));
version = eregmatch(pattern:"ssh-.*openssh[_-]{1}([0-9.]+[p0-9]*)", string: banner);
if(isnull(version[1]))exit(0);

if(version_is_less(version: version[1], test_version: "5.2")) {
 security_warning(port);
 exit(0);
}

exit(0);
