###############################################################################
# OpenVAS Vulnerability Test
# $Id: realty_web_base_detect.nasl 3309 2009-05-10 15:01:14Z mime $
#
# Realty Web-Base Detection
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

 desc["english"] = "

  Overview:
   Realty Web-Base, a content management and customer communication
   suite is running at this host. 

  See also:
   http://www.realtywebware.com

  Risk factor : None";

if (description)
{
 script_id(100194);
 script_version ("1.0");

 script_name(english:"Realty Web-Base Detection");
 script_description(english:desc["english"]);
 script_summary(english:"Checks for the presence of Realty Web-Base");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Service detection");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dirs = make_list("/cms",cgi_dirs());

foreach dir (dirs) {

    url = string(dir, "/admin/index.php"); 
    req = http_get(item:url, port:port);
    buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);

    if( buf == NULL )continue; 
    
    if(egrep(pattern:"Realty Webware [0-9.]+", string: buf) &&
       egrep(pattern:"Set-Cookie: owner", string: buf) )
    {    

         if(strlen(dir)>0) {
            install=dir;
         } else {
            install=string("/");
         }

         vers = string("unknown");

	 version = eregmatch(pattern:"Realty Webware ([0-9.]+)", string:buf);

	 if(!isnull(version[1])) {
           vers = version[1];
	 }  

	 set_kb_item(name: string("www/", port, "/RealtyWebBase"), value: string(vers," under ",install));

         info = string("None\n\nRealty Web-Base Version '");
         info += string(vers);
         info += string("' was detected on the remote host in the following directory(s):\n\n");
         info += string(install, "\n"); 

	desc = ereg_replace(
          string:desc["english"],
          pattern:"None$",
          replace:info
        );

         security_note(port:port,data:desc);
         exit(0);
    }	 
}

exit(0);
