# OpenVAS Vulnerability Test
# $Id$
# Description: detects the version of Microsoft .Net Framework
#
# remote-detect-MSdotNET-version.nasl
#
# Author:
# Christian Eric Edjenguele <christian.edjenguele@owasp.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 and later,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#



if(description)
{
script_id(101007);
name["english"] = "Microsoft dotNET version grabber";
script_name(english:name["english"]);
 
desc["english"] = "
The remote host seems to have Microsoft .NET installed. 



Solution :
It's recommended to disable verbose error displaying to avoid version detection.
this can be done througth the IIS management console.
 



Risk factor : None";

script_description(english:desc["english"]); 

summary["english"] = "The remote host seems to have Microsoft .NET installed";

script_summary(english:summary["english"]);

script_category(ACT_GATHER_INFO);

script_copyright(english:"This script is Written by Christian Eric Edjenguele <christian.edjenguele@owasp.org> and released under GPL v2 or later");
family["english"] = "General";
script_family(english:family["english"]);
script_dependencies("find_service.nes");
script_require_ports("Services/www");



exit(0);

}


#
# The script code starts here
#

include("misc_func.inc");
include("http_func.inc");
include("http_keepalive.inc");


# request a non existant random page
page = string(rand() + ".aspx");

port = get_http_port(default:80);
	
request = string(
    "GET /", page, " HTTP/1.0\r\n",
    "User-Agent: Mozilla/5.0 (X11; U; Linux i686; en-US; OpenVAS)\r\n",
    "Accept-Language: en-us,en;q=0.5\r\n",
    "Keep-Alive: 300\r\n",
    "Connection: keep-alive\r\n",
    "Content-Type: application/x-www-form-urlencoded\r\n\r\n"
    );


	
	# Get back the response
	response = http_keepalive_send_recv(port:port, data:request, bodyonly:1);

	# Get the ASP.NET Microsoft .Net Framework version
	# a response example:
	# Version Information: Microsoft .NET Framework Version:2.0.50727.1433; ASP.NET Version:2.0.50727.1433
	dotNet_header = eregmatch(pattern:"Microsoft .NET Framework Version:([0-9.]+)",string:response, icase:TRUE);
	aspNet_header = eregmatch(pattern:"ASP.NET Version:([0-9.]+)",string:response, icase:TRUE);

	if(('Version Information' >< response) && dotNet_header){
		report = "OpenVAS was able to Detected " + dotNet_header[0];

		# save informations into the kb
		set_kb_item(name:"dotNET/install", value:TRUE);
		set_kb_item(name:"dotNET/port", value:port);
		set_kb_item(name:"dotNet/version", value:dotNet_header[1]);
	
		
		if(aspNET_header >< response){
			report +=  " and " + aspNet_header[0];
	
			# save informations into the kb
			set_kb_item(name:"aspNET/installed", value:TRUE);
			set_kb_item(name:"aspNET/version", value:aspNet_header[1]);
		}
	

		# report all gathered informations
		security_note(port:port, data:report);
	}
