###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_apple_safari_pdf_js_rest_bypass_vuln.nasl 2250 2009-05-14 12:16:43Z may $
#
# Apple Safari PDF Javascript Security Bypass Bypass Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900637);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1600");
  script_name(english:"Apple Safari PDF Javascript Security Bypass Bypass Vulnerability");
  desc["english"] = "

  Overview: The host is installed with Opera Web Browser and is prone to PDF
  Javascript Security Bypass Vulnerability.

  Vulnerability Insight:
  An error in Adobe Acrobat JavaScript protocol handler in the context of browser
  when a PDF file is opened in it via execute DOM calls in response to a
  javascript: URI.

  Impact:
  Successful exploitation will let attacker to execute arbitrary code result in
  spoof URLs, bypass the security restriction, XSS, Memory corruption, phishing
  attacks and steal generic information from website.

  Impact level: Application/Network

  Affected Software/OS:
  Apple Safari 4.28.17.0 and prior on Windows.

  Fix: No solution or patch is available as on 18th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.apple.com/support/downloads

  References:
  http://www.securityfocus.com/archive/1/archive/1/503183/100/0/threaded
  http://secniche.org/papers/SNS_09_03_PDF_Silent_Form_Re_Purp_Attack.pdf

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Apple Safari");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Web application abuses");
  script_dependencies("secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}


include("version_func.inc");

safariVer = get_kb_item("AppleSafari/Version");
if(safariVer == NULL){
  exit(0);
}

if(version_is_less_equal(version:safariVer, test_version:"4.28.17.0")){
  security_hole(0);
}
