#############################################################################
#
#  IBM DB2 Universal Database Multiple Vulnerabilities - Sept08 (Linux)
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/12
#
#  Revision: 1.1 
#
#  Log: veerendragg
#  Issue #0187
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900216);
 script_bugtraq_id(31058);
 script_cve_id("CVE-2008-2154", "CVE-2008-3958", "CVE-2008-3960");
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Denial of Service");
 script_name(english:"IBM DB2 Universal Database Multiple Vulnerabilities - Sept08 (Linux)");
 script_summary(english:"Check for vulnerable version of DB2 Universal Database");
 desc["english"] = "
 Overview : The host is running DB2 Database Server, which is prone to multiple
 vulnerabilities.

 Vulnerability Insight :

        The flaws exists due to unspecified errors in processing of
        - CONNECT/ATTACH requests, 
        - DB2FMP process and DB2JDS service.

        Impact : Remote exploitation could allow attackers to bypass security
        restrictions, cause a denial of service or gain elevated privileges.
 
 Impact Level : Application
 
 Affected Software/OS :
        IBM DB2 version 8 prior to Fixpak 17 on Linux (All).
 
 Fix: Update to Fixpak 17 or later.
 ftp://ftp.software.ibm.com/ps/products/db2/fixes/

 *****
 NOTE : Ignore this warning, if above mentioned patch is already applied.
 *****

 References : http://secunia.com/advisories/31787/
 http://www.frsirt.com/english/advisories/2008/2517
 http://securitytracker.com/alerts/2008/Sep/1020826.html
 http://www-01.ibm.com/support/docview.wss?uid=swg1JR29274
 
 CVSS Score Report :
        CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
        CVSS Temporal Score : 6.1
 Risk factor : High";

 script_description(english:desc["english"]);
 script_dependencies("gather-package-list.nasl",
                     "secpod_ibm_db2_detect_linux_900217.nasl");
 script_require_keys("ssh/login/uname", "Linux/IBM_db2/Ver",
                     "Linux/IBM_db2/FixPack");
 exit(0);
}


 if("Linux" >!< get_kb_item("ssh/login/uname")){
        exit(0);
 }

 if(egrep(pattern:"^8\.[0-2]\..*", string:get_kb_item("Linux/IBM_db2/Ver"))){
 	security_hole(0);
 }
