###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_konqueror_kde_dos_vuln.nasl 748 2008-12-24 14:15:29Z dec $
#
# Konqueror in KDE Denial of Service Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900417);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4514", "CVE-2008-5712");
  script_bugtraq_id(31696);
  script_name(english:"Konqueror in KDE Denial of Service Vulnerability");
  desc["english"] = "

  Overview: This host is running Konqueror and is prone to Denial of Service
  Vulnerability.

  Vulnerability Insight:
  These flaws are due to,
  - improper handling of JavaScript document.load Function calls targeting
    the current document which can cause denial of service.
  - HTML parser in KDE Konqueror causes denial of service via a long attribute
    in HR element or a long BGCOLOR or BORDERCOLOR.

  Impact:
  Successful exploitation will let the attacker to trigger the use of a deleted
  object within the HTMLTokenizer::scriptHandler() method and can cause a crash.

  Affected Software/OS:
  Konqueror in KDE version 3.5.10 or prior.

  Fix:
  No solution or patch is available as on as on 31st December 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.kde.org/download

  References:
  http://www.milw0rm.com/exploits/6718
  http://secunia.com/advisories/32208

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Konqueror");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_family(english:"Denial of Service");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

knqrName = find_file(file_name:"konqueror", file_path:"/", useregex:TRUE,
                     regexpar:"$", sock:sock);
foreach binaryName (knqrName)
{
  binaryName = chomp(binaryName);
  knqrVer= get_bin_version(full_prog_name:binaryName, version_argv:"-v",
                           ver_pattern:"Konqueror: ([0-9.]+)", sock:sock);
  if(knqrVer[1] != NULL)
  {
    # Grep for version 3.5.9 or prior
    if(version_is_less_equal(version:knqrVer[1], test_version:"3.5.9")){
      security_warning(0);
    }
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
