##############################################################################
#
#  MailScanner Infinite Loop Denial of Service Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/12/02
#
#  Revision: 1.0
#
#  Log: sghosal
#  Issue #0547
#
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
##############################################################################

if(description)
{
  script_id(900413);
  script_bugtraq_id(32514);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Denial of Service");
  script_name(english:"MailScanner Infinite Loop Denial of Service Vulnerability");
  script_summary(english:"Check for vulnerable version of MailScanner");
  desc["english"] = "
  Overview: This host is installed with MailScanner and is prone to Denial of
  Service vulnerability.

  Vulnerability Insight:
  This error is due to an issue in 'Clean' Function in message.pm.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in a
  crafted message and it can lead to system crash through high CPU resources.

  Impact Level: Application

  Affected Software/OS:
  MailScanner version prior to 4.73.3-1 on all Linux platforms.

  Fix:
  Upgrade to the latest MailScanner version 4.73.3-1
  http://www.mailscanner.info/downloads.html

  References:
  http://osvdb.org/show/osvdb/50268
  http://secunia.com/Advisories/32915

  CVSS Score:
    CVSS Base Score     : 9.0 (AV:N/AC:L/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 6.6
  Risk factor: High";

  script_description(english:desc["english"]);
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/uname");
  exit(0);
}


include("ssh_func.inc");

if("Linux" >!< get_kb_item("ssh/login/uname")){
  exit(0);
}

sock = ssh_login_or_reuse_connection();
if(sock)
{
  ver = ssh_cmd(socket:sock, cmd:"MailScanner -v", timeout:120);
  ssh_close_connection();
  if("MailScanner" >< ver){
    # Grep for MailScanner version prior to 4.73.3
    pattern = "MailScanner version ([0-3](\..*)|4(\.[0-6]?[0-9](\..*)?|\.7" +
              "[0-2](\..*)?|\.73\.[0-3]))($|[^.0-9])";
    if(egrep(pattern:pattern, string:ver)){
      security_warning(0);
    }
  }
}
