###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mikmod_detect.nasl 879 2009-01-23 17:40:29Z jan $
#
# MikMod Module Player Version Detection (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900442);
  script_version("$Revision: 1.0 $");
  script_name(english:"MikMod Module Player Version Detection (Linux)");
  desc["english"] = "

  Overview: The script detects the version of MikMod Module Player and sets
  result in KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set the KB for the version of Module Player");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"General");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

mikmodPath = find_file(file_name:"mikmod", file_path:"/", useregex:TRUE,
                       regexpar:"$", sock:sock);
foreach binary_mikmodName (mikmodPath)
{
  binary_name = chomp(binary_mikmodName);
  mikmodCmd = get_bin_version(full_prog_name:binary_name, version_argv:"--version",
                              ver_pattern:"MikMod ([0-9]\.[0-9.]+)", sock:sock);
  if(mikmodCmd[1] != NULL)
  {
    set_kb_item(name:"MikMod/Linux/Ver", value:mikmodCmd[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
