##############################################################################
#
#  Virtual Address Descriptor Manipulation Elevation of Privilege Vulnerability (956841)
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/15
#
#  Revision: 1.0
#
#  Log: veerendragg
#  Issue #0329
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900225);
  script_bugtraq_id(31675);
  script_cve_id("CVE-2008-4036");
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows : Microsoft Bulletins");
  script_name(english:"Virtual Address Descriptor Manipulation Elevation of Privilege Vulnerability (956841)");
  script_summary(english:"Check for the Hotfix and version of MS08-064");
  desc["english"] = "
  MS08-064

  Overview: This host is missing important security update according to
  Microsoft Bulletin MS08-064.

  Vulnerability Insight:
  The flaw exists due to the way that Memory Manager handles memory allocation
  and Virtual Address Descriptors (VADs).

  Impact: Successful exploitation could allow elevation of privilege and can
  cause a memory allocation mapping error and corrupt memory on affected system.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows Server 2003 Service Pack 2 and prior.

  Fix: Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/Bulletin/MS08-064.mspx

  References : http://www.microsoft.com/technet/security/Bulletin/MS08-064.mspx

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:L/AC:L/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score : 5.0
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2003:3) <= 0){
  exit(0);
}

# Check for Hotfix 956841 (MS08-064).
if(hotfix_missing(name:"956841") == 0){
  exit(0);
}

# Get System32 Path
sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

exePath = sysPath + "\Ntoskrnl.exe";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);

fileVer = GetVer(file:file, share:share);
if(fileVer == NULL){
  exit(0);
}

if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep Ntoskrnl.exe version < 5.1.2600.3427
    if(egrep(pattern:"^5\.1\.2600\.([0-2]?[0-9]?[0-9]?[0-9]|3([0-3][0-9]" +
                     "[0-9]|4([01][0-9]|2[0-6])))$", string:fileVer)){
      security_warning(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep Ntoskrnl.exe version < 5.1.2600.5657
    if(egrep(pattern:"^5\.1\.2600\.([0-4]?[0-9]?[0-9]?[0-9]|5([0-5][0-9]" +
                     "[0-9]|6([0-4][0-9]|5[0-6])))$", string:fileVer)){
      security_warning(0);
    }
    exit(0);
  }
  security_warning(0);
}

if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Grep Ntoskrnl.exe version < 5.2.3790.3191
    if(egrep(pattern:"^5\.2\.3790\.([0-2]?[0-9]?[0-9]?[0-9]|3(0[0-9][0-9]" +
                     "|1([0-8][0-9]|90)))$", string:fileVer)){
      security_warning(0);
    }
    exit(0);
  }
  else if("Service Pack 2" >< SP)
  {
    # Grep Ntoskrnl.exe version < 5.2.3790.4354
    if(egrep(pattern:"^5\.2\.3790\.([0-3]?[0-9]?[0-9]?[0-9]|4([0-2][0-9]" +
                     "[0-9]|3([0-4][0-9]|5[0-3])))$", string:fileVer)){
      security_warning(0);
    }
    exit(0);
  }
  security_warning(0);
}
