###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-013.nasl 1697 2009-04-15 08:27:50Z apr $
#
# Windows HTTP Services Could Allow Remote Code Execution Vulnerabilities (960803)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900092);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0086", "CVE-2009-0089", "CVE-2009-0550");
  script_bugtraq_id(34435, 34437, 34439);
  script_name(english:"Windows HTTP Services Could Allow Remote Code Execution Vulnerabilities (960803)");
  desc["english"] = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-013.

  Vulnerability Insight:
  - Integer underflow error in Windows HTTP Services allow to execute arbitrary
    code via a specially crafted parameter returned by a malicious web server.
  - Error in Windows HTTP Services while validating the distinguished name
    of a certificate can leads to spoof a valid certificate.
    Successful exploitation requires the ability to perform DNS spoofing attacks.
  - Error in Windows HTTP Services reflect NTLM credentials and execute arbitrary
    code by tricking a user into connecting to a malicious web server.

  Impact:
  Attacker who successfully exploited could allow malicious people to conduct
  spoofing attacks and compromise a user's system.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-013.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms09-013.mspx

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the vulnerable File Version and Hotfix");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check for Hotfix 960803 (MS09-013)
if(hotfix_missing(name:"960803") == 0){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\Winhttp.dll");

sysVer = GetVer(file:file, share:share);
if(!sysVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Winhttp.dll version < 5.1.2600.3490
  if(version_is_less(version:sysVer, test_version:"5.1.2600.3490")){
    security_hole(0);
  }
  exit(0);
}

# Windows XP
if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Winhttp.dll < 5.1.2600.3494
    if(version_is_less(version:sysVer, test_version:"5.1.2600.3494")){
       security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Winhttp.dll < 5.1.2600.5727
    if(version_is_less(version:sysVer, test_version:"5.1.2600.5727")){
       security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

# Windows 2003
if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Grep for Winhttp.dll version < 5.2.3790.3262
    if(version_is_less(version:sysVer, test_version:"5.2.3790.3262")){
       security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 2" >< SP)
  {
    # Grep for Winhttp.dll version < 5.2.3790.4427
    if(version_is_less(version:sysVer, test_version:"5.2.3790.4427")){
       security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
